/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.config.ProcessorConfig;
import com.epam.healenium.handlers.proxy.TargetLocatorProxyInvocationHandler;
import com.epam.healenium.handlers.proxy.WebElementProxyHandler;
import com.epam.healenium.model.Context;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.utils.ProxyFactory;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseHandler.class);
    protected final SelfHealingEngine engine;
    protected final WebDriver driver;
    protected final ProcessorConfig processorConfig;

    public BaseHandler(SelfHealingEngine engine) {
        this.engine = engine;
        this.driver = engine.getWebDriver();
        this.processorConfig = new ProcessorConfig();
    }

    protected WebElement findElement(By by) {
        try {
            PageAwareBy pageBy = this.awareBy(by);
            By inner = pageBy.getBy();
            if (this.engine.isHealingEnabled()) {
                Context context = new Context().setPageAwareBy(pageBy).setAction("findElement");
                BaseProcessor chainProcessor = this.processorConfig.findElementChainProcessor();
                this.setBaseProcessorFields(chainProcessor, context);
                chainProcessor.process();
                return context.getElements().get(0);
            }
            return this.driver.findElement(inner);
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn("Error during findElement: ", (Throwable)ex);
            throw new NoSuchElementException("Failed to find element using " + by.toString(), (Throwable)ex);
        }
    }

    protected List<WebElement> findElements(By by) {
        try {
            PageAwareBy pageBy = this.awareBy(by);
            By inner = pageBy.getBy();
            if (this.engine.isHealingEnabled()) {
                Context context = new Context().setPageAwareBy(pageBy).setAction("findElements");
                BaseProcessor chainProcessor = this.processorConfig.findElementsChainProcessor();
                this.setBaseProcessorFields(chainProcessor, context);
                chainProcessor.process();
                return context.getElements();
            }
            return this.driver.findElements(inner);
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find elements using " + by.toString(), (Throwable)ex);
        }
    }

    protected PageAwareBy awareBy(By by) {
        return by instanceof PageAwareBy ? (PageAwareBy)by : PageAwareBy.by(this.driver.getTitle(), by);
    }

    public WebElement wrapElement(WebElement element, ClassLoader loader) {
        WebElementProxyHandler elementProxyHandler = new WebElementProxyHandler(element, this.engine);
        return ProxyFactory.createWebElementProxy(loader, elementProxyHandler);
    }

    protected WebDriver.TargetLocator wrapTarget(WebDriver.TargetLocator locator, ClassLoader loader) {
        TargetLocatorProxyInvocationHandler handler = new TargetLocatorProxyInvocationHandler(locator, this.engine);
        return ProxyFactory.createTargetLocatorProxy(loader, handler);
    }

    protected void setBaseProcessorFields(BaseProcessor baseProcessor, Context context) {
        baseProcessor.setContext(context).setDriver(this.driver).setEngine(this.engine).setRestClient(this.engine.getClient()).setHealingService(this.engine.getHealingService());
    }
}

