/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import com.epam.healenium.handlers.proxy.SelfHealingProxyInvocationHandler;
import com.epam.healenium.handlers.proxy.WebElementProxyHandler;
import com.epam.healenium.utils.StackUtils;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTraceReader {
    private static final Logger log = LoggerFactory.getLogger(StackTraceReader.class);

    public Optional<StackTraceElement> findOriginCaller(StackTraceElement[] elements) {
        List<StackTraceElement> elementList = this.normalize(elements);
        String callerName = this.getCallerPackageName(elementList);
        if (StringUtils.isBlank((CharSequence)callerName)) {
            return Optional.empty();
        }
        Collections.reverse(elementList);
        return elementList.stream().filter(it -> it.getClassName().startsWith(callerName)).findFirst();
    }

    private List<StackTraceElement> normalize(StackTraceElement[] traceElements) {
        List elementList = Arrays.stream(traceElements).filter(StackUtils.redundantPackages()).collect(Collectors.toList());
        Collections.reverse(elementList);
        elementList = ((StreamEx)StreamEx.of(elementList).takeWhile(it -> !this.getProxyHandlerNames().contains(it.getClassName()))).toList();
        return elementList.subList(0, elementList.size());
    }

    private String getCallerPackageName(List<StackTraceElement> traceElements) {
        String result = "";
        try {
            StackTraceElement element = (StackTraceElement)Iterables.getLast(traceElements);
            String className = element.getClassName();
            int dotPos = this.lastDotPosition(className);
            result = dotPos == -1 ? className : element.getClassName().substring(0, Math.max(dotPos, 0));
        }
        catch (Exception ex) {
            log.warn("Failed to find caller package name", (Throwable)ex);
        }
        return result;
    }

    public List<String> getProxyHandlerNames() {
        return Arrays.asList(SelfHealingProxyInvocationHandler.class.getName(), WebElementProxyHandler.class.getName());
    }

    private int lastDotPosition(String input) {
        int dot1 = input.indexOf(".");
        int dot2 = input.indexOf(".", dot1 + 1);
        return Math.max(dot1, dot2);
    }
}

