/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.processor.BaseProcessor;
import java.util.Collections;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindChildElementProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(FindChildElementProcessor.class);

    public FindChildElementProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public void execute() {
        try {
            PageAwareBy key = this.context.getPageAwareBy();
            WebElement element = this.delegateElement.findElement(key.getBy());
            this.engine.saveElements(key, Collections.singletonList(element));
            this.context.getElements().add(element);
        }
        catch (NoSuchElementException e) {
            log.warn("Failed to find an element using locator {}\nReason: {}\nTrying to heal...", (Object)this.context.getPageAwareBy().getBy().toString(), (Object)e.getMessage());
            this.context.setNoSuchElementException(e);
        }
    }
}

