/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(HealingProcessor.class);

    public HealingProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        LastHealingDataDto lastHealingDataDto = this.context.getLastHealingData();
        if (lastHealingDataDto.getPaths().isEmpty()) {
            log.warn("New element locator have not been found. There is a lack of reference data.");
            throw this.context.getNoSuchElementException();
        }
        return true;
    }

    @Override
    public void execute() {
        String targetPage = this.engine.pageSource();
        Node destination = this.engine.parseTree(targetPage);
        this.context.setPageContent(targetPage);
        for (List<Node> nodes : this.context.getLastHealingData().getPaths()) {
            this.healingService.findNewLocations(nodes, destination, this.context);
        }
    }
}

