/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.ReferenceElementsDto;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");

    public HealingProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        ReferenceElementsDto referenceElementsDto = this.context.getReferenceElementsDto();
        if (referenceElementsDto.getPaths().isEmpty()) {
            log.warn("New element locator have not been found. There is no reference data to selector in the database.\nMake sure that: \n- There is selector on the page {}/selectors/ and type: single, if not then you have to run successful tests.\n- Your locator was changed on the page and not in code.", (Object)this.engine.getClient().getServerUrl());
            throw this.context.getNoSuchElementException();
        }
        return true;
    }

    @Override
    public void execute() {
        String targetPage = this.engine.pageSource();
        Node destination = this.engine.parseTree(targetPage);
        this.context.setPageContent(targetPage);
        for (List<Node> nodes : this.context.getReferenceElementsDto().getPaths()) {
            this.healingService.findNewLocations(nodes, destination, this.context);
        }
    }
}

