/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium;

import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.handlers.proxy.SelfHealingProxyInvocationHandler;
import com.epam.healenium.mapper.HealeniumMapper;
import com.epam.healenium.model.SessionContext;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.service.NodeService;
import com.epam.healenium.utils.ProxyFactory;
import com.epam.healenium.utils.StackTraceReader;
import com.typesafe.config.Config;
import org.openqa.selenium.WebDriver;

public interface SelfHealingDriver
extends WebDriver {
    public SelfHealingEngine getCurrentEngine();

    public <T extends WebDriver> T getDelegate();

    public static SelfHealingDriver create(WebDriver delegate) {
        SelfHealingEngine selfHealingEngine = new SelfHealingEngine(delegate);
        SelfHealingDriver.setEngineFields(delegate, selfHealingEngine);
        SelfHealingDriver.callInitActions(selfHealingEngine);
        return SelfHealingDriver.create(selfHealingEngine);
    }

    public static SelfHealingDriver create(WebDriver delegate, Config config) {
        SelfHealingEngine selfHealingEngine = new SelfHealingEngine(delegate, config);
        SelfHealingDriver.setEngineFields(delegate, selfHealingEngine);
        SelfHealingDriver.callInitActions(selfHealingEngine);
        return SelfHealingDriver.create(selfHealingEngine);
    }

    public static void setEngineFields(WebDriver delegate, SelfHealingEngine selfHealingEngine) {
        Config finalizedConfig = selfHealingEngine.getConfig();
        HealeniumMapper healeniumMapper = new HealeniumMapper(new StackTraceReader());
        RestClient restClient = new RestClient(finalizedConfig);
        restClient.setMapper(healeniumMapper);
        selfHealingEngine.setClient(restClient);
        selfHealingEngine.setNodeService(new NodeService());
        selfHealingEngine.setHealingService(new HealingService(finalizedConfig, delegate));
        selfHealingEngine.setSessionContext(new SessionContext());
    }

    public static void callInitActions(SelfHealingEngine selfHealingEngine) {
        selfHealingEngine.loadStoredSelectors();
        selfHealingEngine.initReport();
    }

    public static SelfHealingDriver create(SelfHealingEngine engine) {
        ClassLoader classLoader = SelfHealingDriver.class.getClassLoader();
        Class<?> driverClass = engine.getWebDriver().getClass();
        SelfHealingProxyInvocationHandler handler = new SelfHealingProxyInvocationHandler(engine);
        return ProxyFactory.createDriverProxy(classLoader, handler, driverClass);
    }
}

