/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.config.ProcessorConfig;
import com.epam.healenium.handlers.SelfHealingHandler;
import com.epam.healenium.handlers.proxy.TargetLocatorProxyInvocationHandler;
import com.epam.healenium.handlers.proxy.WebElementProxyHandler;
import com.epam.healenium.model.Context;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.utils.ProxyFactory;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHandler
implements SelfHealingHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");
    protected final SelfHealingEngine engine;
    protected final WebDriver driver;
    protected BaseProcessor findElementChainProcessor;
    protected BaseProcessor findElementsChainProcessor;

    public BaseHandler(SelfHealingEngine engine) {
        this.engine = engine;
        this.driver = engine.getWebDriver();
        this.findElementChainProcessor = ProcessorConfig.findElementChainProcessor();
        this.findElementsChainProcessor = ProcessorConfig.findElementsChainProcessor();
    }

    @Override
    public WebElement findElement(By by) {
        try {
            if (this.engine.getSessionContext().isWaitCommand()) {
                this.engine.getSessionContext().setFindElementWaitCommand(true);
            }
            if (this.engine.isHealingEnabled()) {
                Context context = new Context().setBy(by).setAction("findElement");
                this.setBaseProcessorFields(this.findElementChainProcessor, context);
                this.findElementChainProcessor.process();
                if (context.getElements().size() > 0) {
                    return context.getElements().get(0);
                }
                if (context.getNoSuchElementException() != null) {
                    throw context.getNoSuchElementException();
                }
                throw new NoSuchElementException("Failed to find element using " + by.toString());
            }
            return this.driver.findElement(by);
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn("Error during findElement: ", (Throwable)ex);
            throw new NoSuchElementException("Failed to find element using " + by.toString(), (Throwable)ex);
        }
    }

    @Override
    public List<WebElement> findElements(By by) {
        if (this.engine.getSessionContext().isWaitCommand()) {
            this.engine.getSessionContext().setFindElementWaitCommand(true);
        }
        if (this.engine.isHealingEnabled()) {
            Context context = new Context().setBy(by).setAction("findElements");
            this.setBaseProcessorFields(this.findElementsChainProcessor, context);
            this.findElementsChainProcessor.process();
            return context.getElements();
        }
        return this.driver.findElements(by);
    }

    protected PageAwareBy awareBy(By by) {
        return by instanceof PageAwareBy ? (PageAwareBy)by : PageAwareBy.by(null, by);
    }

    @Override
    public WebElement wrapElement(WebElement element, ClassLoader loader) {
        WebElementProxyHandler elementProxyHandler = new WebElementProxyHandler(element, this.engine);
        return ProxyFactory.createWebElementProxy(loader, elementProxyHandler);
    }

    @Override
    public WebDriver.TargetLocator wrapTarget(WebDriver.TargetLocator locator, ClassLoader loader) {
        TargetLocatorProxyInvocationHandler handler = new TargetLocatorProxyInvocationHandler(locator, this.engine);
        return ProxyFactory.createTargetLocatorProxy(loader, handler);
    }

    @Override
    public void quit() {
        this.engine.quit();
    }

    protected void setBaseProcessorFields(BaseProcessor baseProcessor, Context context) {
        baseProcessor.setContext(context).setDriver(this.driver).setEngine(this.engine).setRestClient(this.engine.getClient()).setHealingService(this.engine.getHealingService());
    }
}

