/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.mojo;

import com.epam.healenium.client.HealingClient;
import com.epam.healenium.extension.ReportHelper;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="buildReport")
public class BuildReportMojo
extends AbstractMojo {
    private final String configFile = "/healenium.properties";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Model model = this.project.getModel();
            Build build = model.getBuild();
            String targetDir = build.getDirectory() + "/classes";
            Properties configProperty = ReportHelper.loadConfig(Paths.get(targetDir + "/healenium.properties", new String[0]).toFile());
            String sessionKey = configProperty.getProperty("sessionKey");
            String serverHost = configProperty.getProperty("serverHost");
            int serverPort = Integer.parseInt(configProperty.getProperty("serverPort"));
            HealingClient client = new HealingClient(serverHost, serverPort);
            String reportUrlResponse = client.buildReport(sessionKey);
            String reportUrl = new URI("http", null, serverHost, serverPort, "/" + reportUrlResponse, null, null).normalize().toString();
            this.getLog().info((CharSequence)("Report available at " + reportUrl));
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Failed to perform init action", (Throwable)ex);
        }
    }
}

