/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.treecomparing;

import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeDistance;
import com.epam.healenium.treecomparing.Utils;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class HeuristicNodeDistance
implements NodeDistance {
    private static final double POINTS_FOR_TAG = 100.0;
    private static final double POINTS_FOR_LCS = 100.0;
    private static final double POINTS_FOR_ID = 50.0;
    private static final double POINTS_FOR_CLASS = 40.0;
    private static final double POINTS_FOR_VALUE = 30.0;
    private static final double POINTS_FOR_INDEX = 0.0;
    private static final double POINTS_FOR_OTHER_ATTRIBUTE = 30.0;

    @Override
    public double distance(Node node1, Node node2, int LCSDistance, int curPathHeight) {
        double score = 0.0;
        if (curPathHeight == 0 || curPathHeight > 5 && (double)LCSDistance / (double)curPathHeight < 0.7) {
            return 0.0;
        }
        score += (double)LCSDistance / (double)curPathHeight * 100.0;
        Set<String> propertyNames = Utils.union(node1.getOtherAttributes().keySet(), node2.getOtherAttributes().keySet());
        Set<String> classNames = Utils.union(node1.getClasses(), node2.getClasses());
        double maximumScore = 350.0;
        if (StringUtils.equalsIgnoreCase((CharSequence)node1.getTag(), (CharSequence)node2.getTag())) {
            score += 100.0;
        }
        if (Objects.equals(node1.getIndex(), node2.getIndex())) {
            score += 0.0;
        }
        if (Objects.equals(node1.getId(), node2.getId())) {
            score += 50.0;
        }
        score += 30.0 * this.calculateLevenshteinScore(node1.getInnerText(), node2.getInnerText(), 0.3);
        Set<String> classesIntersect = Utils.intersect(node1.getClasses(), node2.getClasses());
        double intersectScore = (double)classesIntersect.size() * 40.0;
        score = classNames.size() > 0 ? (score += (intersectScore /= (double)classNames.size())) : (score += 40.0);
        Set<String> node1classesDifference = Utils.difference(node1.getClasses(), node2.getClasses());
        Set<String> node2classesDifference = Utils.difference(node2.getClasses(), node1.getClasses());
        int lengthDifference = Utils.union(node1classesDifference, node2classesDifference).size();
        if (lengthDifference > 0) {
            double classesScore = 0.0;
            classesScore = node1classesDifference.size() > 0 ? this.calculateClassesIntersectionByLevenshtein(node1classesDifference, node2.getClasses()) : this.calculateClassesIntersectionByLevenshtein(node1.getClasses(), node2classesDifference);
            if (classNames.size() > 0) {
                classesScore /= (double)classNames.size();
            }
            score += (double)lengthDifference * 40.0 * classesScore;
        }
        double otherAttributesScore = 0.0;
        for (String propertyName : propertyNames) {
            otherAttributesScore += 30.0 * this.calculateLevenshteinScore(node1.getOtherAttributes().get(propertyName), node2.getOtherAttributes().get(propertyName), 0.75);
        }
        score = propertyNames.size() > 0 ? (score += (otherAttributesScore /= (double)propertyNames.size())) : (score += 30.0);
        return score / maximumScore;
    }

    private double calculateClassesIntersectionByLevenshtein(Set<String> nodeClasses1, Set<String> nodeClasses2) {
        int comparisonsNumber = 0;
        double scores = 0.0;
        for (String classNameFirst : nodeClasses1) {
            for (String classNameSecond : nodeClasses2) {
                scores += this.calculateLevenshteinScore(classNameFirst, classNameSecond, 0.75);
                ++comparisonsNumber;
            }
        }
        if (comparisonsNumber == 0) {
            return 0.0;
        }
        return scores / (double)comparisonsNumber;
    }

    public double calculateLevenshteinScore(String innerText1, String innerText2, double thresholdPercent) {
        if (innerText1 == null || innerText2 == null) {
            return 0.0;
        }
        innerText1 = innerText1.toLowerCase();
        innerText2 = innerText2.toLowerCase();
        int length = Math.max(innerText1.length(), innerText2.length());
        if (length == 0) {
            return 1.0;
        }
        if (this.isBoolean(innerText1) || this.isBoolean(innerText2)) {
            return innerText1.equals(innerText2) ? 1.0 : 0.0;
        }
        int threshold = this.calculateLevenshteinThreshold(length, thresholdPercent);
        LevenshteinDistance levenshtein = new LevenshteinDistance(Integer.valueOf(threshold));
        Integer distance = levenshtein.apply((CharSequence)innerText1, (CharSequence)innerText2);
        if (distance < 0) {
            return 0.0;
        }
        return ((double)length - distance.doubleValue()) / (double)length;
    }

    private boolean isBoolean(String value) {
        return "true".equals(value) || "false".equals(value);
    }

    private int calculateLevenshteinThreshold(int maxTextLength, double thresholdPercent) {
        return (int)((double)maxTextLength * thresholdPercent + 1.0);
    }
}

