/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.codec;

import com.facebook.nifty.codec.ThriftFrameDecoder;
import com.facebook.nifty.core.TNiftyTransport;
import com.facebook.nifty.core.ThriftMessage;
import com.facebook.nifty.core.ThriftTransportType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class DefaultThriftFrameDecoder
extends ThriftFrameDecoder {
    public static final int MESSAGE_FRAME_SIZE = 4;
    private final int maxFrameSize;
    private final TProtocolFactory inputProtocolFactory;

    public DefaultThriftFrameDecoder(int maxFrameSize, TProtocolFactory inputProtocolFactory) {
        this.maxFrameSize = maxFrameSize;
        this.inputProtocolFactory = inputProtocolFactory;
    }

    @Override
    protected ThriftMessage decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (!buffer.readable()) {
            return null;
        }
        short firstByte = buffer.getUnsignedByte(0);
        if (firstByte >= 128) {
            ChannelBuffer messageBuffer = this.tryDecodeUnframedMessage(ctx, channel, buffer, this.inputProtocolFactory);
            if (messageBuffer == null) {
                return null;
            }
            return new ThriftMessage(messageBuffer, ThriftTransportType.UNFRAMED);
        }
        if (buffer.readableBytes() < 4) {
            return null;
        }
        ChannelBuffer messageBuffer = this.tryDecodeFramedMessage(ctx, channel, buffer, true);
        if (messageBuffer == null) {
            return null;
        }
        return new ThriftMessage(messageBuffer, ThriftTransportType.FRAMED);
    }

    protected ChannelBuffer tryDecodeFramedMessage(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, boolean stripFraming) {
        int messageStartReaderIndex = buffer.readerIndex();
        int messageContentsOffset = stripFraming ? messageStartReaderIndex + 4 : messageStartReaderIndex;
        int messageLength = buffer.getInt(messageStartReaderIndex) + 4;
        int messageContentsLength = messageStartReaderIndex + messageLength - messageContentsOffset;
        if (messageContentsLength > this.maxFrameSize) {
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TooLongFrameException("Maximum frame size of " + this.maxFrameSize + " exceeded"));
        }
        if (messageLength == 0) {
            buffer.readerIndex(messageContentsOffset);
            return null;
        }
        if (buffer.readableBytes() < messageLength) {
            return null;
        }
        ChannelBuffer messageBuffer = this.extractFrame(buffer, messageContentsOffset, messageContentsLength);
        buffer.readerIndex(messageStartReaderIndex + messageLength);
        return messageBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelBuffer tryDecodeUnframedMessage(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, TProtocolFactory inputProtocolFactory) throws TException {
        int messageLength = 0;
        int messageStartReaderIndex = buffer.readerIndex();
        try {
            TNiftyTransport decodeAttemptTransport = new TNiftyTransport(channel, buffer, ThriftTransportType.UNFRAMED);
            int initialReadBytes = decodeAttemptTransport.getReadByteCount();
            TProtocol inputProtocol = inputProtocolFactory.getProtocol((TTransport)decodeAttemptTransport);
            inputProtocol.readMessageBegin();
            TProtocolUtil.skip((TProtocol)inputProtocol, (byte)12);
            inputProtocol.readMessageEnd();
            messageLength = decodeAttemptTransport.getReadByteCount() - initialReadBytes;
        }
        catch (IndexOutOfBoundsException | TTransportException e) {
            ChannelBuffer channelBuffer = null;
            return channelBuffer;
        }
        finally {
            if (buffer.readerIndex() - messageStartReaderIndex > this.maxFrameSize) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TooLongFrameException("Maximum frame size of " + this.maxFrameSize + " exceeded"));
            }
            buffer.readerIndex(messageStartReaderIndex);
        }
        if (messageLength <= 0) {
            return null;
        }
        ChannelBuffer messageBuffer = this.extractFrame(buffer, messageStartReaderIndex, messageLength);
        buffer.readerIndex(messageStartReaderIndex + messageLength);
        return messageBuffer;
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

