/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.codec;

import com.facebook.nifty.codec.ThriftFrameEncoder;
import com.facebook.nifty.core.ThriftMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class DefaultThriftFrameEncoder
extends ThriftFrameEncoder {
    private final long maxFrameSize;

    public DefaultThriftFrameEncoder(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected ChannelBuffer encode(ChannelHandlerContext ctx, Channel channel, ThriftMessage message) throws Exception {
        int frameSize = message.getBuffer().readableBytes();
        if ((long)message.getBuffer().readableBytes() > this.maxFrameSize) {
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new TooLongFrameException(String.format("Frame size exceeded on encode: frame was %d bytes, maximum allowed is %d bytes", frameSize, this.maxFrameSize)));
            return null;
        }
        switch (message.getTransportType()) {
            case UNFRAMED: {
                return message.getBuffer();
            }
            case FRAMED: {
                ChannelBuffer frameSizeBuffer = ChannelBuffers.buffer((int)4);
                frameSizeBuffer.writeInt(message.getBuffer().readableBytes());
                return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{frameSizeBuffer, message.getBuffer()});
            }
            case HEADER: {
                throw new UnsupportedOperationException("Header transport is not supported");
            }
            case HTTP: {
                throw new UnsupportedOperationException("HTTP transport is not supported");
            }
        }
        throw new UnsupportedOperationException("Unrecognized transport type");
    }
}

