/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.NiftyMetrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;

public class ChannelStatistics
extends SimpleChannelHandler
implements NiftyMetrics {
    private final AtomicInteger channelCount = new AtomicInteger(0);
    private final AtomicLong bytesRead = new AtomicLong(0L);
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private final ChannelGroup allChannels;
    public static final String NAME = ChannelStatistics.class.getSimpleName();

    public ChannelStatistics(ChannelGroup allChannels) {
        this.allChannels = allChannels;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        UpstreamMessageEvent ume;
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)e;
            switch (cse.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(cse.getValue())) {
                        this.channelCount.incrementAndGet();
                        this.allChannels.add((Object)e.getChannel());
                        break;
                    }
                    this.channelCount.decrementAndGet();
                    this.allChannels.remove((Object)e.getChannel());
                    break;
                }
            }
        }
        if (e instanceof UpstreamMessageEvent && (ume = (UpstreamMessageEvent)e).getMessage() instanceof ChannelBuffer) {
            ChannelBuffer cb = (ChannelBuffer)ume.getMessage();
            int readableBytes = cb.readableBytes();
            this.bytesRead.getAndAdd(readableBytes);
        }
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        DownstreamMessageEvent dme;
        if (e instanceof DownstreamMessageEvent && (dme = (DownstreamMessageEvent)e).getMessage() instanceof ChannelBuffer) {
            ChannelBuffer cb = (ChannelBuffer)dme.getMessage();
            int readableBytes = cb.readableBytes();
            this.bytesWritten.getAndAdd(readableBytes);
        }
        ctx.sendDownstream(e);
    }

    @Override
    public int getChannelCount() {
        return this.channelCount.get();
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead.get();
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten.get();
    }
}

