/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.util.Timer;

public abstract class NettyConfigBuilderBase<T extends NettyConfigBuilderBase<T>> {
    public static final int DEFAULT_BOSS_THREAD_COUNT = 1;
    public static final int DEFAULT_WORKER_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private String niftyName;
    private int bossThreadCount = 1;
    private int workerThreadCount = DEFAULT_WORKER_THREAD_COUNT;
    private ExecutorService bossThreadExecutor;
    private ExecutorService workerThreadExecutor;
    private Timer timer;

    public Map<String, Object> getBootstrapOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public T setTimer(Timer timer) {
        this.timer = timer;
        return (T)this;
    }

    protected Timer getTimer() {
        return this.timer;
    }

    protected T setNiftyName(String niftyName) {
        Preconditions.checkNotNull((Object)niftyName, (Object)"niftyName cannot be null");
        this.niftyName = niftyName;
        return (T)this;
    }

    public String getNiftyName() {
        return this.niftyName;
    }

    public T setBossThreadExecutor(ExecutorService bossThreadExecutor) {
        this.bossThreadExecutor = bossThreadExecutor;
        return (T)this;
    }

    protected ExecutorService getBossExecutor() {
        return this.bossThreadExecutor;
    }

    public T setBossThreadCount(int bossThreadCount) {
        this.bossThreadCount = bossThreadCount;
        return (T)this;
    }

    protected int getBossThreadCount() {
        return this.bossThreadCount;
    }

    public T setWorkerThreadExecutor(ExecutorService workerThreadExecutor) {
        this.workerThreadExecutor = workerThreadExecutor;
        return (T)this;
    }

    protected ExecutorService getWorkerExecutor() {
        return this.workerThreadExecutor;
    }

    public T setWorkerThreadCount(int workerThreadCount) {
        this.workerThreadCount = workerThreadCount;
        return (T)this;
    }

    protected int getWorkerThreadCount() {
        return this.workerThreadCount;
    }

    protected class Magic
    implements InvocationHandler {
        private final String prefix;

        public Magic(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (proxy != null) {
                if (method.getName().equals("toString")) {
                    return "this is a magic proxy";
                }
                if (method.getName().equals("equals")) {
                    return Boolean.FALSE;
                }
                if (method.getName().equals("hashCode")) {
                    return 0;
                }
            }
            if (method.getName().startsWith("set") && args.length == 1) {
                String attributeName = method.getName().substring(3);
                attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
                NettyConfigBuilderBase.this.options.put(this.prefix + attributeName, args[0]);
                return null;
            }
            throw new UnsupportedOperationException();
        }
    }
}

