/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.ChannelStatistics;
import com.facebook.nifty.core.ConnectionContextHandler;
import com.facebook.nifty.core.IdleDisconnectHandler;
import com.facebook.nifty.core.NettyServerConfig;
import com.facebook.nifty.core.NiftyDispatcher;
import com.facebook.nifty.core.NiftyExceptionLogger;
import com.facebook.nifty.core.NiftyMetrics;
import com.facebook.nifty.core.NiftySecurityHandlers;
import com.facebook.nifty.core.ShutdownUtil;
import com.facebook.nifty.core.ThriftServerDef;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerTransport
implements ExternalResourceReleasable {
    private static final Logger log = LoggerFactory.getLogger(NettyServerTransport.class);
    private final int port;
    private final ChannelPipelineFactory pipelineFactory;
    private static final int NO_WRITER_IDLE_TIMEOUT = 0;
    private static final int NO_ALL_IDLE_TIMEOUT = 0;
    private ServerBootstrap bootstrap;
    private final ChannelGroup allChannels;
    private ExecutorService bossExecutor;
    private ExecutorService ioWorkerExecutor;
    private ServerChannelFactory channelFactory;
    private Channel serverChannel;
    private final ThriftServerDef def;
    private final NettyServerConfig nettyServerConfig;
    private final ChannelStatistics channelStatistics;

    public NettyServerTransport(ThriftServerDef def) {
        this(def, NettyServerConfig.newBuilder().build(), (ChannelGroup)new DefaultChannelGroup());
    }

    @Inject
    public NettyServerTransport(final ThriftServerDef def, final NettyServerConfig nettyServerConfig, ChannelGroup allChannels) {
        this.def = def;
        this.nettyServerConfig = nettyServerConfig;
        this.port = def.getServerPort();
        this.allChannels = allChannels;
        final ConnectionLimiter connectionLimiter = new ConnectionLimiter(def.getMaxConnections());
        this.channelStatistics = new ChannelStatistics(allChannels);
        this.pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                TProtocolFactory inputProtocolFactory = def.getDuplexProtocolFactory().getInputProtocolFactory();
                NiftySecurityHandlers securityHandlers = def.getSecurityFactory().getSecurityHandlers(def, nettyServerConfig);
                cp.addLast("connectionContext", (ChannelHandler)new ConnectionContextHandler());
                cp.addLast("connectionLimiter", (ChannelHandler)connectionLimiter);
                cp.addLast(ChannelStatistics.NAME, (ChannelHandler)NettyServerTransport.this.channelStatistics);
                cp.addLast("encryptionHandler", securityHandlers.getEncryptionHandler());
                cp.addLast("frameCodec", def.getThriftFrameCodecFactory().create(def.getMaxFrameSize(), inputProtocolFactory));
                if (def.getClientIdleTimeout() != null) {
                    cp.addLast("idleTimeoutHandler", (ChannelHandler)new IdleStateHandler(nettyServerConfig.getTimer(), def.getClientIdleTimeout().toMillis(), 0L, 0L, TimeUnit.MILLISECONDS));
                    cp.addLast("idleDisconnectHandler", (ChannelHandler)new IdleDisconnectHandler());
                }
                cp.addLast("authHandler", securityHandlers.getAuthenticationHandler());
                cp.addLast("dispatcher", (ChannelHandler)new NiftyDispatcher(def, nettyServerConfig.getTimer()));
                cp.addLast("exceptionLogger", (ChannelHandler)new NiftyExceptionLogger());
                return cp;
            }
        };
    }

    public void start() {
        this.bossExecutor = this.nettyServerConfig.getBossExecutor();
        int bossThreadCount = this.nettyServerConfig.getBossThreadCount();
        this.ioWorkerExecutor = this.nettyServerConfig.getWorkerExecutor();
        int ioWorkerThreadCount = this.nettyServerConfig.getWorkerThreadCount();
        this.channelFactory = new NioServerSocketChannelFactory((BossPool)new NioServerBossPool((Executor)this.bossExecutor, bossThreadCount, ThreadNameDeterminer.CURRENT), (WorkerPool)new NioWorkerPool((Executor)this.ioWorkerExecutor, ioWorkerThreadCount, ThreadNameDeterminer.CURRENT));
        this.start(this.channelFactory);
    }

    public void start(ServerChannelFactory serverChannelFactory) {
        if (!(InternalLoggerFactory.getDefaultFactory() instanceof Slf4JLoggerFactory)) {
            log.warn("Nifty always logs to slf4j, but netty is currently configured to use a different logging implementation. To correct this call InternalLoggerFactory.setDefaultFactory(new Slf4JLoggerFactory()) during your server's startup");
        }
        this.bootstrap = new ServerBootstrap((ChannelFactory)serverChannelFactory);
        this.bootstrap.setOptions(this.nettyServerConfig.getBootstrapOptions());
        this.bootstrap.setPipelineFactory(this.pipelineFactory);
        this.serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        SocketAddress actualSocket = this.serverChannel.getLocalAddress();
        if (actualSocket instanceof InetSocketAddress) {
            int actualPort = ((InetSocketAddress)actualSocket).getPort();
            log.info("started transport {}:{} (:{})", new Object[]{this.def.getName(), actualPort, this.port});
        } else {
            log.info("started transport {}:{}", (Object)this.def.getName(), (Object)this.port);
        }
    }

    public void stop() throws InterruptedException {
        if (this.serverChannel != null) {
            log.info("stopping transport {}:{}", (Object)this.def.getName(), (Object)this.port);
            final CountDownLatch latch = new CountDownLatch(1);
            this.serverChannel.close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (NettyServerTransport.this.def.getExecutor() instanceof ExecutorService) {
                        ExecutorService exe = (ExecutorService)NettyServerTransport.this.def.getExecutor();
                        ShutdownUtil.shutdownExecutor(exe, "dispatcher");
                    }
                    latch.countDown();
                }
            });
            latch.await();
            this.serverChannel = null;
        }
        if (this.channelFactory != null) {
            ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.channelFactory, this.bossExecutor, this.ioWorkerExecutor, this.allChannels);
        }
    }

    public Channel getServerChannel() {
        return this.serverChannel;
    }

    public void releaseExternalResources() {
        this.bootstrap.releaseExternalResources();
    }

    public NiftyMetrics getMetrics() {
        return this.channelStatistics;
    }

    private static class ConnectionLimiter
    extends SimpleChannelUpstreamHandler {
        private final AtomicInteger numConnections;
        private final int maxConnections;

        public ConnectionLimiter(int maxConnections) {
            this.maxConnections = maxConnections;
            this.numConnections = new AtomicInteger(0);
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.maxConnections > 0 && this.numConnections.incrementAndGet() > this.maxConnections) {
                ctx.getChannel().close();
                log.info("Accepted connection above limit ({}). Dropping.", (Object)this.maxConnections);
            }
            super.channelOpen(ctx, e);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.maxConnections > 0 && this.numConnections.decrementAndGet() < 0) {
                log.error("BUG in ConnectionLimiter");
            }
            super.channelClosed(ctx, e);
        }
    }
}

