/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.NettyServerConfig;
import com.facebook.nifty.core.NettyServerTransport;
import com.facebook.nifty.core.NiftyMetrics;
import com.facebook.nifty.core.ShutdownUtil;
import com.facebook.nifty.core.ThriftServerDef;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NiftyBootstrap {
    private final ChannelGroup allChannels;
    private final NettyServerConfig nettyServerConfig;
    private final Map<ThriftServerDef, NettyServerTransport> transports;
    private ExecutorService bossExecutor;
    private ExecutorService workerExecutor;
    private NioServerSocketChannelFactory serverChannelFactory;

    @Inject
    public NiftyBootstrap(Set<ThriftServerDef> thriftServerDefs, NettyServerConfig nettyServerConfig, ChannelGroup allChannels) {
        this.allChannels = allChannels;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.nettyServerConfig = nettyServerConfig;
        for (ThriftServerDef thriftServerDef : thriftServerDefs) {
            builder.put((Object)thriftServerDef, (Object)new NettyServerTransport(thriftServerDef, nettyServerConfig, allChannels));
        }
        this.transports = builder.build();
    }

    @PostConstruct
    public void start() {
        this.bossExecutor = this.nettyServerConfig.getBossExecutor();
        this.workerExecutor = this.nettyServerConfig.getWorkerExecutor();
        this.serverChannelFactory = new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor);
        for (NettyServerTransport transport : this.transports.values()) {
            transport.start((ServerChannelFactory)this.serverChannelFactory);
        }
    }

    @PreDestroy
    public void stop() {
        for (NettyServerTransport transport : this.transports.values()) {
            try {
                transport.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.serverChannelFactory, this.bossExecutor, this.workerExecutor, this.allChannels);
    }

    public Map<ThriftServerDef, NiftyMetrics> getNiftyMetrics() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<ThriftServerDef, NettyServerTransport> entry : this.transports.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getMetrics());
        }
        return builder.build();
    }
}

