/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.core.RequestContext;
import com.google.common.base.Preconditions;

public class RequestContexts {
    private static ThreadLocal<RequestContext> threadLocalContext = new ThreadLocal();

    private RequestContexts() {
    }

    public static RequestContext getCurrentContext() {
        RequestContext currentContext = threadLocalContext.get();
        Preconditions.checkState((currentContext != null ? 1 : 0) != 0, (Object)"Can only get a RequestContext when running inside a Thrift handler");
        return currentContext;
    }

    public static void setCurrentContext(RequestContext requestContext) {
        threadLocalContext.set(requestContext);
    }

    public static void clearCurrentContext() {
        threadLocalContext.remove();
    }
}

