/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

@NotThreadSafe
public class TChannelBufferOutputTransport
extends TTransport {
    private static final int DEFAULT_MINIMUM_SIZE = 1024;
    private static final int UNDER_USE_THRESHOLD = 5;
    private ChannelBuffer outputBuffer;
    private final int minimumSize;
    private int bufferUnderUsedCounter;

    public TChannelBufferOutputTransport() {
        this.minimumSize = 1024;
        this.outputBuffer = ChannelBuffers.dynamicBuffer((int)this.minimumSize);
    }

    public TChannelBufferOutputTransport(int minimumSize) {
        this.minimumSize = Math.min(1024, minimumSize);
        this.outputBuffer = ChannelBuffers.dynamicBuffer((int)this.minimumSize);
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.outputBuffer.writeBytes(buf, off, len);
    }

    public void resetOutputBuffer() {
        int shrunkenSize = this.shrinkBufferSize();
        this.bufferUnderUsedCounter = this.outputBuffer.writerIndex() < shrunkenSize ? ++this.bufferUnderUsedCounter : 0;
        if (this.shouldShrinkBuffer()) {
            this.outputBuffer = ChannelBuffers.dynamicBuffer((int)shrunkenSize);
            this.bufferUnderUsedCounter = 0;
        } else {
            this.outputBuffer.clear();
        }
    }

    public ChannelBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    private boolean shouldShrinkBuffer() {
        return this.bufferUnderUsedCounter > 5 && this.shrinkBufferSize() >= this.minimumSize;
    }

    private int shrinkBufferSize() {
        return this.outputBuffer.capacity() >> 1;
    }
}

