/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.core;

import com.facebook.nifty.codec.DefaultThriftFrameCodecFactory;
import com.facebook.nifty.codec.ThriftFrameCodecFactory;
import com.facebook.nifty.core.NiftyNoOpSecurityFactory;
import com.facebook.nifty.core.NiftySecurityFactory;
import com.facebook.nifty.core.ThriftServerDef;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.nifty.processor.NiftyProcessorAdapters;
import com.facebook.nifty.processor.NiftyProcessorFactory;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public abstract class ThriftServerDefBuilderBase<T extends ThriftServerDefBuilderBase<T>> {
    private static final AtomicInteger ID = new AtomicInteger(1);
    private ThriftFrameCodecFactory thriftFrameCodecFactory;
    private int serverPort = 8080;
    private int maxFrameSize = 0x4000000;
    private int maxConnections = 0;
    private int queuedResponseLimit = 16;
    private NiftyProcessorFactory niftyProcessorFactory;
    private TProcessorFactory thriftProcessorFactory;
    private TDuplexProtocolFactory duplexProtocolFactory;
    private Executor executor;
    private String name = "nifty-" + ID.getAndIncrement();
    private Duration clientIdleTimeout = null;
    private Duration taskTimeout = null;
    private NiftySecurityFactory securityFactory;
    private static final int MAX_FRAME_SIZE = 0x4000000;

    public ThriftServerDefBuilderBase() {
        this.duplexProtocolFactory = TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true));
        this.executor = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
        this.thriftFrameCodecFactory = new DefaultThriftFrameCodecFactory();
        this.securityFactory = new NiftyNoOpSecurityFactory();
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T listen(int serverPort) {
        this.serverPort = serverPort;
        return (T)this;
    }

    public T protocol(TDuplexProtocolFactory tProtocolFactory) {
        this.duplexProtocolFactory = tProtocolFactory;
        return (T)this;
    }

    public T protocol(TProtocolFactory tProtocolFactory) {
        this.duplexProtocolFactory = TDuplexProtocolFactory.fromSingleFactory(tProtocolFactory);
        return (T)this;
    }

    public T withProcessor(final NiftyProcessor processor) {
        this.niftyProcessorFactory = new NiftyProcessorFactory(){

            @Override
            public NiftyProcessor getProcessor(TTransport transport) {
                return processor;
            }
        };
        return (T)this;
    }

    public T withProcessor(TProcessor processor) {
        this.thriftProcessorFactory = new TProcessorFactory(processor);
        return (T)this;
    }

    public T withProcessorFactory(NiftyProcessorFactory processorFactory) {
        this.niftyProcessorFactory = processorFactory;
        return (T)this;
    }

    public T withProcessorFactory(TProcessorFactory processorFactory) {
        this.thriftProcessorFactory = processorFactory;
        return (T)this;
    }

    public T limitFrameSizeTo(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return (T)this;
    }

    public T limitConnectionsTo(int maxConnections) {
        this.maxConnections = maxConnections;
        return (T)this;
    }

    public T limitQueuedResponsesPerConnection(int queuedResponseLimit) {
        this.queuedResponseLimit = queuedResponseLimit;
        return (T)this;
    }

    public T clientIdleTimeout(Duration clientIdleTimeout) {
        this.clientIdleTimeout = clientIdleTimeout;
        return (T)this;
    }

    public T taskTimeout(Duration taskTimeout) {
        this.taskTimeout = taskTimeout;
        return (T)this;
    }

    public T thriftFrameCodecFactory(ThriftFrameCodecFactory thriftFrameCodecFactory) {
        this.thriftFrameCodecFactory = thriftFrameCodecFactory;
        return (T)this;
    }

    public T using(Executor exe) {
        this.executor = exe;
        return (T)this;
    }

    public T withSecurityFactory(NiftySecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
        return (T)this;
    }

    public ThriftServerDef build() {
        Preconditions.checkState((this.niftyProcessorFactory != null || this.thriftProcessorFactory != null ? 1 : 0) != 0, (Object)"Processor not defined!");
        Preconditions.checkState((this.niftyProcessorFactory == null || this.thriftProcessorFactory == null ? 1 : 0) != 0, (Object)"TProcessors will be automatically adapted to NiftyProcessors, don't specify both");
        Preconditions.checkState((this.maxConnections >= 0 ? 1 : 0) != 0, (Object)"maxConnections should be 0 (for unlimited) or positive");
        if (this.niftyProcessorFactory == null) {
            this.niftyProcessorFactory = NiftyProcessorAdapters.factoryFromTProcessorFactory(this.thriftProcessorFactory);
        }
        return new ThriftServerDef(this.name, this.serverPort, this.maxFrameSize, this.queuedResponseLimit, this.maxConnections, this.niftyProcessorFactory, this.duplexProtocolFactory, this.clientIdleTimeout, this.taskTimeout, this.thriftFrameCodecFactory, this.executor, this.securityFactory);
    }
}

