/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.processor;

import com.facebook.nifty.core.RequestContext;
import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.nifty.processor.NiftyProcessorFactory;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class NiftyProcessorAdapters {
    public static NiftyProcessor processorFromTProcessor(final TProcessor standardThriftProcessor) {
        NiftyProcessorAdapters.checkProcessMethodSignature();
        return new NiftyProcessor(){

            @Override
            public ListenableFuture<Boolean> process(TProtocol in, TProtocol out, RequestContext requestContext) throws TException {
                return Futures.immediateFuture((Object)standardThriftProcessor.process(in, out));
            }
        };
    }

    public static NiftyProcessorFactory factoryFromTProcessor(final TProcessor standardThriftProcessor) {
        NiftyProcessorAdapters.checkProcessMethodSignature();
        return new NiftyProcessorFactory(){

            @Override
            public NiftyProcessor getProcessor(TTransport transport) {
                return NiftyProcessorAdapters.processorFromTProcessor(standardThriftProcessor);
            }
        };
    }

    public static NiftyProcessorFactory factoryFromTProcessorFactory(final TProcessorFactory standardThriftProcessorFactory) {
        NiftyProcessorAdapters.checkProcessMethodSignature();
        return new NiftyProcessorFactory(){

            @Override
            public NiftyProcessor getProcessor(TTransport transport) {
                return NiftyProcessorAdapters.processorFromTProcessor(standardThriftProcessorFactory.getProcessor(transport));
            }
        };
    }

    public static TProcessor processorToTProcessor(final NiftyProcessor niftyProcessor) {
        return new TProcessor(){

            public boolean process(TProtocol in, TProtocol out) throws TException {
                try {
                    return (Boolean)niftyProcessor.process(in, out, null).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new TException((Throwable)e);
                }
            }
        };
    }

    public static TProcessorFactory processorToTProcessorFactory(NiftyProcessor niftyProcessor) {
        return new TProcessorFactory(NiftyProcessorAdapters.processorToTProcessor(niftyProcessor));
    }

    public static TProcessorFactory processorFactoryToTProcessorFactory(final NiftyProcessorFactory niftyProcessorFactory) {
        return new TProcessorFactory(null){

            public TProcessor getProcessor(TTransport trans) {
                return NiftyProcessorAdapters.processorToTProcessor(niftyProcessorFactory.getProcessor(trans));
            }
        };
    }

    private static void checkProcessMethodSignature() {
        try {
            TProcessor.class.getMethod("process", TProtocol.class, TProtocol.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("The loaded TProcessor class is not supported by version of the adapters");
        }
    }
}

