/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.AbstractMetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

public class RpcInstrumentation
implements MetricsSource {
    static final Log LOG = LogFactory.getLog(RpcInstrumentation.class);
    final MetricsRegistry registry = new MetricsRegistry("rpc");
    final MetricMutableCounterInt authenticationSuccesses = this.registry.newCounter("rpcAuthenticationSuccesses", "RPC authentication successes count", 0);
    final MetricMutableCounterInt authenticationFailures = this.registry.newCounter("rpcAuthenticationFailures", "RPC authentication failures count", 0);
    final MetricMutableCounterInt authorizationSuccesses = this.registry.newCounter("rpcAuthorizationSuccesses", "RPC authorization successes count", 0);
    final MetricMutableCounterInt authorizationFailures = this.registry.newCounter("rpcAuthorizationFailures", "RPC authorization failures count", 0);
    final MetricMutableCounterLong receivedBytes = this.registry.newCounter("ReceivedBytes", "RPC received bytes count", 0L);
    final MetricMutableCounterLong sentBytes = this.registry.newCounter("SentBytes", "RPC sent bytes count", 0L);
    final MetricMutableStat rpcQueueTime = this.registry.newStat("RpcQueueTime", "RPC queue time stats", "ops", "time");
    final MetricMutableStat rpcProcessingTime = this.registry.newStat("RpcProcessingTime", "RPC processing time", "ops", "time");
    final MetricMutableGaugeInt numOpenConnections = this.registry.newGauge("NumOpenConnections", "Number of open connections", 0);
    final MetricMutableGaugeInt callQueueLen = this.registry.newGauge("callQueueLen", "RPC call queue length", 0);
    final Detailed detailed;

    RpcInstrumentation(String serverName, int port) {
        String portStr = String.valueOf(port);
        this.registry.setContext("rpc").tag("port", "RPC port", portStr);
        this.detailed = new Detailed(portStr);
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }

    public static RpcInstrumentation create(String serverName, int port) {
        return RpcInstrumentation.create(serverName, port, DefaultMetricsSystem.INSTANCE);
    }

    public static RpcInstrumentation create(String serverName, int port, MetricsSystem ms) {
        RpcInstrumentation rpc = new RpcInstrumentation(serverName, port);
        ms.register("RpcDetailedActivityForPort" + port, "Per call", rpc.detailed());
        return ms.register("RpcActivityForPort" + port, "Aggregate metrics", rpc);
    }

    public MetricsSource detailed() {
        return this.detailed;
    }

    public void incrAuthenticationFailures() {
        this.authenticationFailures.incr();
    }

    public void incrAuthenticationSuccesses() {
        this.authenticationSuccesses.incr();
    }

    public void incrAuthorizationSuccesses() {
        this.authorizationSuccesses.incr();
    }

    public void incrAuthorizationFailures() {
        this.authorizationFailures.incr();
    }

    public void shutdown() {
        LOG.info("shut down");
    }

    public void incrSentBytes(int count) {
        this.sentBytes.incr(count);
    }

    public void incrReceivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    public void addRpcQueueTime(int qTime) {
        this.rpcQueueTime.add(qTime);
    }

    public void addRpcProcessingTime(int processingTime) {
        this.rpcProcessingTime.add(processingTime);
    }

    public void addRpcProcessingTime(String methodName, int processingTime) {
        this.detailed.addRpcProcessingTime(methodName, processingTime);
    }

    public static class Detailed
    extends AbstractMetricsSource {
        Detailed(String port) {
            super("rpcdetailed");
            this.registry.setContext("rpcdetailed").tag("port", "RPC port", port);
        }

        public synchronized void addRpcProcessingTime(String methodName, int processingTime) {
            this.registry.add(methodName, processingTime);
        }
    }
}

