/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Joiner;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNUpgradeUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class BootstrapStandby
implements Tool,
Configurable {
    private static final Log LOG = LogFactory.getLog(BootstrapStandby.class);
    private String nsId;
    private String nnId;
    private String otherNNId;
    private URL otherHttpAddr;
    private InetSocketAddress otherIpcAddr;
    private Collection<URI> dirsToFormat;
    private List<URI> editUrisToFormat;
    private List<URI> sharedEditsUris;
    private Configuration conf;
    private boolean force = false;
    private boolean interactive = true;
    private boolean skipSharedEditsCheck = false;
    static final int ERR_CODE_FAILED_CONNECT = 2;
    static final int ERR_CODE_INVALID_VERSION = 3;
    static final int ERR_CODE_ALREADY_FORMATTED = 5;
    static final int ERR_CODE_LOGS_UNAVAILABLE = 6;

    @Override
    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        this.parseConfAndFindOtherNN();
        NameNode.checkAllowFormat(this.conf);
        InetSocketAddress myAddr = NameNode.getAddress(this.conf);
        SecurityUtil.login(this.conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", myAddr.getHostName());
        return SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return BootstrapStandby.this.doRun();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if ("-force".equals(arg)) {
                this.force = true;
                continue;
            }
            if ("-nonInteractive".equals(arg)) {
                this.interactive = false;
                continue;
            }
            if ("-skipSharedEditsCheck".equals(arg)) {
                this.skipSharedEditsCheck = true;
                continue;
            }
            this.printUsage();
            throw new HadoopIllegalArgumentException("Illegal argument: " + arg);
        }
    }

    private void printUsage() {
        System.err.println("Usage: " + this.getClass().getSimpleName() + " [-force] [-nonInteractive] [-skipSharedEditsCheck]");
    }

    private NamenodeProtocol createNNProtocolProxy() throws IOException {
        return NameNodeProxies.createNonHAProxy(this.getConf(), this.otherIpcAddr, NamenodeProtocol.class, UserGroupInformation.getLoginUser(), true).getProxy();
    }

    private int doRun() throws IOException {
        int download;
        boolean isUpgradeFinalized;
        NamespaceInfo nsInfo;
        NamenodeProtocol proxy = this.createNNProtocolProxy();
        try {
            nsInfo = proxy.versionRequest();
            isUpgradeFinalized = proxy.isUpgradeFinalized();
        }
        catch (IOException ioe) {
            LOG.fatal("Unable to fetch namespace information from active NN at " + this.otherIpcAddr + ": " + ioe.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Full exception trace", ioe);
            }
            return 2;
        }
        if (!this.checkLayoutVersion(nsInfo)) {
            LOG.fatal("Layout version on remote node (" + nsInfo.getLayoutVersion() + ") does not match " + "this node's layout version (" + HdfsConstants.NAMENODE_LAYOUT_VERSION + ")");
            return 3;
        }
        System.out.println("=====================================================\nAbout to bootstrap Standby ID " + this.nnId + " from:\n" + "           Nameservice ID: " + this.nsId + "\n" + "        Other Namenode ID: " + this.otherNNId + "\n" + "  Other NN's HTTP address: " + this.otherHttpAddr + "\n" + "  Other NN's IPC  address: " + this.otherIpcAddr + "\n" + "             Namespace ID: " + nsInfo.getNamespaceID() + "\n" + "            Block pool ID: " + nsInfo.getBlockPoolID() + "\n" + "               Cluster ID: " + nsInfo.getClusterID() + "\n" + "           Layout version: " + nsInfo.getLayoutVersion() + "\n" + "       isUpgradeFinalized: " + isUpgradeFinalized + "\n" + "=====================================================");
        NNStorage storage = new NNStorage(this.conf, this.dirsToFormat, this.editUrisToFormat);
        if (!isUpgradeFinalized) {
            LOG.info("The active NameNode is in Upgrade. Prepare the upgrade for the standby NameNode as well.");
            if (!this.doPreUpgrade(storage, nsInfo)) {
                return 5;
            }
        } else if (!this.format(storage, nsInfo)) {
            return 5;
        }
        if ((download = this.downloadImage(storage, proxy)) != 0) {
            return download;
        }
        if (!isUpgradeFinalized) {
            this.doUpgrade(storage);
        }
        return 0;
    }

    private boolean format(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        if (!Storage.confirmFormat(storage.dirIterable(null), this.force, this.interactive)) {
            storage.close();
            return false;
        }
        storage.format(nsInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPreUpgrade(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        boolean isFormatted = false;
        HashMap<Storage.StorageDirectory, Storage.StorageState> dataDirStates = new HashMap<Storage.StorageDirectory, Storage.StorageState>();
        try {
            isFormatted = FSImage.recoverStorageDirs(HdfsServerConstants.StartupOption.UPGRADE, storage, dataDirStates);
            if (dataDirStates.values().contains((Object)Storage.StorageState.NOT_FORMATTED)) {
                isFormatted = false;
                System.err.println("The original storage directory is not formatted.");
            }
        }
        catch (InconsistentFSStateException e) {
            LOG.warn("The storage directory is in an inconsistent state", e);
        }
        finally {
            storage.unlockAll();
        }
        if (!isFormatted && !this.format(storage, nsInfo)) {
            return false;
        }
        FSImage.checkUpgrade(storage);
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                NNUpgradeUtil.renameCurToTmp(sd);
            }
            catch (IOException e) {
                LOG.error("Failed to move aside pre-upgrade storage in image directory " + sd.getRoot(), e);
                throw e;
            }
        }
        storage.setStorageInfo(nsInfo);
        storage.setBlockPoolID(nsInfo.getBlockPoolID());
        return true;
    }

    private void doUpgrade(NNStorage storage) throws IOException {
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            NNUpgradeUtil.doUpgrade(sd, storage);
        }
    }

    private int downloadImage(NNStorage storage, NamenodeProtocol proxy) throws IOException {
        long imageTxId = proxy.getMostRecentCheckpointTxId();
        long curTxId = proxy.getTransactionID();
        FSImage image = new FSImage(this.conf);
        try {
            image.getStorage().setStorageInfo(storage);
            image.initEditLog(HdfsServerConstants.StartupOption.REGULAR);
            assert (image.getEditLog().isOpenForRead()) : "Expected edit log to be open for read";
            if (!this.skipSharedEditsCheck && !this.checkLogsAvailableForRead(image, imageTxId, curTxId)) {
                return 6;
            }
            image.getStorage().writeTransactionIdFileToStorage(curTxId);
            MD5Hash hash = TransferFsImage.downloadImageToStorage(this.otherHttpAddr, imageTxId, storage, true);
            image.saveDigestAndRenameCheckpointImage(NNStorage.NameNodeFile.IMAGE, imageTxId, hash);
        }
        catch (IOException ioe) {
            image.close();
            throw ioe;
        }
        return 0;
    }

    private boolean checkLogsAvailableForRead(FSImage image, long imageTxId, long curTxIdOnOtherNode) {
        if (imageTxId == curTxIdOnOtherNode) {
            return true;
        }
        long firstTxIdInLogs = imageTxId + 1L;
        assert (curTxIdOnOtherNode >= firstTxIdInLogs) : "first=" + firstTxIdInLogs + " onOtherNode=" + curTxIdOnOtherNode;
        try {
            Collection<EditLogInputStream> streams = image.getEditLog().selectInputStreams(firstTxIdInLogs, curTxIdOnOtherNode, null, true);
            for (EditLogInputStream stream : streams) {
                IOUtils.closeStream(stream);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "Unable to read transaction ids " + firstTxIdInLogs + "-" + curTxIdOnOtherNode + " from the configured shared edits storage " + Joiner.on(",").join(this.sharedEditsUris) + ". " + "Please copy these logs into the shared edits storage " + "or call saveNamespace on the active node.\n" + "Error: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                LOG.fatal(msg, e);
            } else {
                LOG.fatal(msg);
            }
            return false;
        }
    }

    private boolean checkLayoutVersion(NamespaceInfo nsInfo) throws IOException {
        return nsInfo.getLayoutVersion() == HdfsConstants.NAMENODE_LAYOUT_VERSION;
    }

    private void parseConfAndFindOtherNN() throws IOException {
        Configuration conf = this.getConf();
        this.nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (!HAUtil.isHAEnabled(conf, this.nsId)) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        this.nnId = HAUtil.getNameNodeId(conf, this.nsId);
        NameNode.initializeGenericKeys(conf, this.nsId, this.nnId);
        if (!HAUtil.usesSharedEditsDir(conf)) {
            throw new HadoopIllegalArgumentException("Shared edits storage is not enabled for this namenode.");
        }
        Configuration otherNode = HAUtil.getConfForOtherNode(conf);
        this.otherNNId = HAUtil.getNameNodeId(otherNode, this.nsId);
        this.otherIpcAddr = NameNode.getServiceAddress(otherNode, true);
        Preconditions.checkArgument(this.otherIpcAddr.getPort() != 0 && !this.otherIpcAddr.getAddress().isAnyLocalAddress(), "Could not determine valid IPC address for other NameNode (%s), got: %s", this.otherNNId, this.otherIpcAddr);
        String scheme = DFSUtil.getHttpClientScheme(conf);
        this.otherHttpAddr = DFSUtil.getInfoServerWithDefaultHost(this.otherIpcAddr.getHostName(), otherNode, scheme).toURL();
        this.dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        this.editUrisToFormat = FSNamesystem.getNamespaceEditsDirs(conf, false);
        this.sharedEditsUris = FSNamesystem.getSharedEditsDirs(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = DFSHAAdmin.addSecurityConfiguration(conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static int run(String[] argv, Configuration conf) throws IOException {
        BootstrapStandby bs = new BootstrapStandby();
        bs.setConf(conf);
        try {
            return ToolRunner.run(bs, argv);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

