/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.S3ObjectsChunk;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.S3Service;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.S3ServiceException;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.acl.AccessControlList;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.BytesProgressWatcher;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.InterruptableInputStream;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.ProgressMonitoredInputStream;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.model.S3Bucket;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.model.S3Object;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.CancelEventTrigger;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.CopyObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.CreateBucketsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.CreateObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.DeleteObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.DownloadObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.DownloadPackage;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.GetObjectHeadsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.GetObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.ListObjectsEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.LookupACLEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.S3ServiceEventListener;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.ServiceEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.ThreadWatcher;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.UpdateACLEvent;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.security.AWSCredentials;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.utils.ServiceUtils;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.utils.signedurl.SignedUrlAndObject;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.utils.signedurl.SignedUrlHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class S3ServiceMulti
implements Serializable {
    private static final long serialVersionUID = -1031831146656816336L;
    private static final Log log = LogFactory.getLog(S3ServiceMulti.class);
    private S3Service s3Service = null;
    private ArrayList serviceEventListeners = new ArrayList();
    private final long sleepTime;
    static /* synthetic */ Class class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager;

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener) {
        this(s3Service, listener, 500L);
    }

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener, long threadSleepTimeMS) {
        this.s3Service = s3Service;
        this.addServiceEventListener(listener);
        this.sleepTime = threadSleepTimeMS;
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        int maxConnectionCount = this.s3Service.getJetS3tProperties().getIntProperty("httpclient.max-connections", 4);
        if (maxConnectionCount < maxThreadCount && log.isWarnEnabled()) {
            log.warn("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + maxThreadCount + " simultaneous threads (s3service.max-thread-count) - please adjust JetS3t settings");
        }
        if (maxConnectionCount < adminMaxThreadCount && log.isWarnEnabled()) {
            log.warn("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + adminMaxThreadCount + " simultaneous admin threads (s3service.admin-max-thread-count) - please adjust JetS3t settings");
        }
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    public void addServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.add(listener);
        }
    }

    public void removeServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.remove(listener);
        }
    }

    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0 && log.isWarnEnabled()) {
            log.warn("S3ServiceMulti invoked without any S3ServiceEventListener objects, this is dangerous!");
        }
        Iterator listenerIter = this.serviceEventListeners.iterator();
        while (listenerIter.hasNext()) {
            S3ServiceEventListener listener = (S3ServiceEventListener)listenerIter.next();
            if (event instanceof CreateObjectsEvent) {
                listener.s3ServiceEventPerformed((CreateObjectsEvent)event);
                continue;
            }
            if (event instanceof CopyObjectsEvent) {
                listener.s3ServiceEventPerformed((CopyObjectsEvent)event);
                continue;
            }
            if (event instanceof CreateBucketsEvent) {
                listener.s3ServiceEventPerformed((CreateBucketsEvent)event);
                continue;
            }
            if (event instanceof ListObjectsEvent) {
                listener.s3ServiceEventPerformed((ListObjectsEvent)event);
                continue;
            }
            if (event instanceof DeleteObjectsEvent) {
                listener.s3ServiceEventPerformed((DeleteObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectsEvent) {
                listener.s3ServiceEventPerformed((GetObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectHeadsEvent) {
                listener.s3ServiceEventPerformed((GetObjectHeadsEvent)event);
                continue;
            }
            if (event instanceof LookupACLEvent) {
                listener.s3ServiceEventPerformed((LookupACLEvent)event);
                continue;
            }
            if (event instanceof UpdateACLEvent) {
                listener.s3ServiceEventPerformed((UpdateACLEvent)event);
                continue;
            }
            if (event instanceof DownloadObjectsEvent) {
                listener.s3ServiceEventPerformed((DownloadObjectsEvent)event);
                continue;
            }
            throw new IllegalArgumentException("Listener not invoked for event class: " + event.getClass());
        }
    }

    public boolean isAuthenticatedConnection() {
        return this.s3Service.isAuthenticatedConnection();
    }

    public AWSCredentials getAWSCredentials() {
        return this.s3Service.getAWSCredentials();
    }

    public boolean listObjects(String bucketName, String[] prefixes, String delimiter, long maxListingLength) {
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        AbstractRunnable[] runnables = new ListObjectsRunnable[prefixes.length];
        for (int i = 0; i < runnables.length; ++i) {
            runnables[i] = new ListObjectsRunnable(bucketName, prefixes[i], delimiter, maxListingLength, null);
        }
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List chunkList) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newInProgressEvent(threadWatcher, chunkList, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newCancelledEvent(uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean createBuckets(S3Bucket[] buckets) {
        final ArrayList<S3Bucket> incompletedBucketList = new ArrayList<S3Bucket>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new CreateBucketRunnable[buckets.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedBucketList.add(buckets[i]);
            runnables[i] = new CreateBucketRunnable(buckets[i]);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedBucketList.removeAll(completedResults);
                S3Bucket[] completedBuckets = completedResults.toArray(new S3Bucket[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newInProgressEvent(threadWatcher, completedBuckets, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Bucket[] incompletedBuckets = incompletedBucketList.toArray(new S3Bucket[incompletedBucketList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCancelledEvent(incompletedBuckets, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean copyObjects(String sourceBucketName, String destinationBucketName, final String[] sourceObjectKeys, final S3Object[] destinationObjects, boolean replaceMetadata) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new CopyObjectRunnable[sourceObjectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(destinationObjects[i]);
            runnables[i] = new CopyObjectRunnable(sourceBucketName, destinationBucketName, sourceObjectKeys[i], destinationObjects[i], replaceMetadata);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        ThreadWatcher threadWatcher = new ThreadWatcher(runnables.length);
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher, ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                Map[] copyResults = completedResults.toArray(new Map[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newInProgressEvent(threadWatcher, copyResults, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newCompletedEvent(uniqueOperationId, sourceObjectKeys, destinationObjects));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new CreateObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(objects[i]);
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            runnables[i] = new CreateObjectRunnable(bucket, objects[i], progressMonitor);
            progressWatchers.add(progressMonitor);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher, ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new DeleteObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            objectsToDeleteList.add(objects[i]);
            runnables[i] = new DeleteObjectRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjects(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjects(bucket, objectKeys);
    }

    public boolean getObjects(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], false);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsHeads(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucket, objectKeys);
    }

    public boolean getObjectsHeads(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], true);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new GetACLRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new PutACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new PutACLRunnable(bucket, objects[i]);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean downloadObjects(S3Bucket bucket, DownloadPackage[] downloadPackages) throws S3ServiceException {
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompleteObjectDownloadList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        boolean restoreLastModifiedDate = this.s3Service.getJetS3tProperties().getBoolProperty("downloads.restoreLastModifiedDate", false);
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        S3Object[] objects = new S3Object[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            if (downloadPackages[i].isSignedDownload()) {
                try {
                    URL url = new URL(downloadPackages[i].getSignedUrl());
                    objects[i] = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                }
                catch (Exception e) {
                    throw new S3ServiceException("Unable to determine S3 Object key name from signed URL: " + downloadPackages[i].getSignedUrl());
                }
            } else {
                objects[i] = downloadPackages[i].getObject();
            }
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            incompleteObjectDownloadList.add(objects[i]);
            progressWatchers.add(progressMonitor);
            runnables[i] = downloadPackages[i].isSignedDownload() ? new DownloadObjectRunnable(downloadPackages[i], progressMonitor, restoreLastModifiedDate) : new DownloadObjectRunnable(bucket, objects[i].getKey(), downloadPackages[i], progressMonitor, restoreLastModifiedDate);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher, ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompleteObjects = incompleteObjectDownloadList.toArray(new S3Object[incompleteObjectDownloadList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean downloadObjects(DownloadPackage[] downloadPackages) throws S3ServiceException {
        for (int i = 0; i < downloadPackages.length; ++i) {
            if (downloadPackages[i].isSignedDownload()) continue;
            throw new S3ServiceException("The downloadObjects(DownloadPackage[]) method may only be used with download packages based on signed URLs. Download package " + (i + 1) + " of " + downloadPackages.length + " is not based on a signed URL");
        }
        return this.downloadObjects(null, downloadPackages);
    }

    public boolean getObjects(String[] signedGetURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetObjectRunnable[signedGetURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedGetURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedGetURLs[i], false);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsHeads(String[] signedHeadURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjectsHeads(String[] signedHeadURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetObjectRunnable[signedHeadURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedHeadURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedHeadURLs[i], true);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjectsACLs(String[] signedURLs, AccessControlList acl) throws MalformedURLException, UnsupportedEncodingException {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new PutACLRunnable[signedURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectsList.add(object);
            runnables[i] = new PutACLRunnable(signedURLs[i], acl);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteObjects(String[] signedDeleteUrls) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method deleteObjects(String[] signedDeleteURLs) available");
        }
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new DeleteObjectRunnable[signedDeleteUrls.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedDeleteUrls[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            objectsToDeleteList.add(object);
            runnables[i] = new DeleteObjectRunnable(signedDeleteUrls[i]);
        }
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, adminMaxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) available");
        }
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        S3Object[] objects = new S3Object[signedPutUrlAndObjects.length];
        for (int i = 0; i < signedPutUrlAndObjects.length; ++i) {
            objects[i] = signedPutUrlAndObjects[i].getObject();
        }
        AbstractRunnable[] runnables = new SignedPutRunnable[signedPutUrlAndObjects.length];
        for (int i = 0; i < runnables.length; ++i) {
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            progressWatchers.add(progressMonitor);
            incompletedObjectsList.add(signedPutUrlAndObjects[i].getObject());
            runnables[i] = new SignedPutRunnable(signedPutUrlAndObjects[i], progressMonitor);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, maxThreadCount, threadWatcher, ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsACLs(String[] signedAclURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{false};
        AbstractRunnable[] runnables = new GetACLRunnable[signedAclURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedAclURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetACLRunnable(signedAclURLs[i]);
        }
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 4);
        boolean ignoreExceptions = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.ignore-exceptions-in-multi", false);
        new ThreadGroupManager(runnables, maxThreadCount, new ThreadWatcher(runnables.length), ignoreExceptions){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList cancelledObjectsList = new ArrayList();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    cancelledObjectsList.add(iter.next());
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                success[0] = true;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    private abstract class ThreadGroupManager {
        private final Log log = LogFactory.getLog(class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager == null ? (class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager = S3ServiceMulti.class$("com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.S3ServiceMulti$ThreadGroupManager")) : class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager);
        private int maxThreadCount = 1;
        private AbstractRunnable[] runnables = null;
        private Thread[] threads = null;
        private boolean ignoreExceptions = false;
        private boolean[] started = null;
        private boolean[] alreadyFired = null;
        private ThreadWatcher threadWatcher = null;
        private long lastProgressEventFiredTime = 0L;

        public ThreadGroupManager(AbstractRunnable[] runnables, int maxThreadCount, ThreadWatcher threadWatcher, boolean ignoreExceptions) {
            this.runnables = runnables;
            this.maxThreadCount = maxThreadCount;
            this.threadWatcher = threadWatcher;
            this.ignoreExceptions = ignoreExceptions;
            this.threads = new Thread[runnables.length];
            this.started = new boolean[runnables.length];
            this.alreadyFired = new boolean[runnables.length];
        }

        private ResultsTuple getNewlyCompletedResults() throws Throwable {
            ArrayList<Object> completedResults = new ArrayList<Object>();
            ArrayList<Throwable> errorResults = new ArrayList<Throwable>();
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.alreadyFired[i] || !this.started[i] || this.threads[i].isAlive()) continue;
                this.alreadyFired[i] = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Thread " + (i + 1) + " of " + this.threads.length + " has recently completed, releasing resources");
                }
                if (this.runnables[i].getResult() instanceof Throwable) {
                    Throwable throwable = (Throwable)this.runnables[i].getResult();
                    this.runnables[i] = null;
                    this.threads[i] = null;
                    if (this.ignoreExceptions) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("Ignoring exception (property s3service.ignore-exceptions-in-multi is set to true)", throwable);
                        }
                        errorResults.add(throwable);
                        continue;
                    }
                    throw throwable;
                }
                completedResults.add(this.runnables[i].getResult());
                this.runnables[i] = null;
                this.threads[i] = null;
            }
            Throwable[] ignoredErrors = new Throwable[]{};
            if (errorResults.size() > 0) {
                ignoredErrors = errorResults.toArray(new Throwable[errorResults.size()]);
            }
            return new ResultsTuple(completedResults, ignoredErrors);
        }

        private void startPendingThreads() throws Throwable {
            int i;
            int runningThreadCount = 0;
            for (i = 0; i < this.runnables.length; ++i) {
                if (!this.started[i] || this.alreadyFired[i]) continue;
                ++runningThreadCount;
            }
            for (i = 0; runningThreadCount < this.maxThreadCount && i < this.started.length; ++i) {
                if (this.started[i]) continue;
                this.threads[i] = new Thread(this.runnables[i]);
                this.threads[i].start();
                this.started[i] = true;
                ++runningThreadCount;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Thread " + (i + 1) + " of " + this.runnables.length + " has started");
            }
        }

        private int getPendingThreadCount() {
            int pendingThreadCount = 0;
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.alreadyFired[i]) continue;
                ++pendingThreadCount;
            }
            return pendingThreadCount;
        }

        private void forceInterruptAllRunnables() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting force interrupt flag on all runnables");
            }
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.runnables[i] == null) continue;
                this.runnables[i].forceInterrupt();
                this.runnables[i] = null;
            }
        }

        public void run() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started ThreadManager");
            }
            boolean[] interrupted = new boolean[]{false};
            CancelEventTrigger cancelEventTrigger = new CancelEventTrigger(this, interrupted){
                private static final long serialVersionUID = 6328417466929608235L;
                private final /* synthetic */ boolean[] val$interrupted;
                private final /* synthetic */ ThreadGroupManager this$1;
                {
                    this.this$1 = this$1;
                    this.val$interrupted = val$interrupted;
                }

                public void cancelTask(Object eventSource) {
                    if (ThreadGroupManager.access$300(this.this$1).isDebugEnabled()) {
                        ThreadGroupManager.access$300(this.this$1).debug("Cancel task invoked on ThreadManager");
                    }
                    this.val$interrupted[0] = true;
                    ThreadGroupManager.access$400(this.this$1);
                }
            };
            try {
                ResultsTuple results;
                int completedThreads;
                this.startPendingThreads();
                this.threadWatcher.updateThreadsCompletedCount(0L, cancelEventTrigger);
                this.fireStartEvent(this.threadWatcher);
                while (!interrupted[0] && this.getPendingThreadCount() > 0) {
                    try {
                        Thread.sleep(100L);
                        if (interrupted[0]) continue;
                        if (System.currentTimeMillis() - this.lastProgressEventFiredTime > S3ServiceMulti.this.sleepTime) {
                            completedThreads = this.runnables.length - this.getPendingThreadCount();
                            this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                            results = this.getNewlyCompletedResults();
                            this.lastProgressEventFiredTime = System.currentTimeMillis();
                            this.fireProgressEvent(this.threadWatcher, results.completedResults);
                            if (results.errorResults.length > 0) {
                                this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                            }
                        }
                        this.startPendingThreads();
                    }
                    catch (InterruptedException e) {
                        interrupted[0] = true;
                        this.forceInterruptAllRunnables();
                    }
                }
                if (interrupted[0]) {
                    this.fireCancelEvent();
                } else {
                    completedThreads = this.runnables.length - this.getPendingThreadCount();
                    this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                    results = this.getNewlyCompletedResults();
                    this.fireProgressEvent(this.threadWatcher, results.completedResults);
                    if (results.completedResults.size() > 0 && this.log.isDebugEnabled()) {
                        this.log.debug(results.completedResults.size() + " threads have recently completed");
                    }
                    if (results.errorResults.length > 0) {
                        this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                    }
                    this.fireCompletedEvent();
                }
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("A thread failed with an exception. Firing ERROR event and cancelling all threads", t);
                }
                this.forceInterruptAllRunnables();
                this.fireErrorEvent(t);
            }
        }

        public abstract void fireStartEvent(ThreadWatcher var1);

        public abstract void fireProgressEvent(ThreadWatcher var1, List var2);

        public abstract void fireCompletedEvent();

        public abstract void fireCancelEvent();

        public abstract void fireErrorEvent(Throwable var1);

        public abstract void fireIgnoredErrorsEvent(ThreadWatcher var1, Throwable[] var2);

        static /* synthetic */ Log access$300(ThreadGroupManager x0) {
            return x0.log;
        }

        static /* synthetic */ void access$400(ThreadGroupManager x0) {
            x0.forceInterruptAllRunnables();
        }

        private class ResultsTuple {
            public List completedResults = null;
            public Throwable[] errorResults = null;

            public ResultsTuple(List completedResults, Throwable[] errorResults) {
                this.completedResults = completedResults;
                this.errorResults = errorResults;
            }
        }
    }

    private class SignedPutRunnable
    extends AbstractRunnable {
        private SignedUrlAndObject signedUrlAndObject;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private Object result;

        public SignedPutRunnable(SignedUrlAndObject signedUrlAndObject, BytesProgressWatcher progressMonitor) {
            this.signedUrlAndObject = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.result = null;
            this.signedUrlAndObject = signedUrlAndObject;
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                if (this.signedUrlAndObject.getObject().getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.signedUrlAndObject.getObject().getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.signedUrlAndObject.getObject().setDataInputStream(pmInputStream);
                }
                SignedUrlHandler signedPutUploader = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                this.result = signedPutUploader.putObjectWithSignedUrl(this.signedUrlAndObject.getSignedUrl(), this.signedUrlAndObject.getObject());
                Object var3_3 = null;
                try {
                    this.signedUrlAndObject.getObject().closeDataInputStream();
                }
                catch (IOException e2) {
                    if (log.isErrorEnabled()) {
                        log.error("Unable to close Object's input stream", e2);
                    }
                    break block11;
                }
                {
                    catch (S3ServiceException e) {
                        this.result = e;
                        Object var3_4 = null;
                        try {
                            this.signedUrlAndObject.getObject().closeDataInputStream();
                        }
                        catch (IOException e2) {
                            if (log.isErrorEnabled()) {
                                log.error("Unable to close Object's input stream", e2);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block12: {
                        Object var3_5 = null;
                        try {
                            this.signedUrlAndObject.getObject().closeDataInputStream();
                        }
                        catch (IOException e2) {
                            if (!log.isErrorEnabled()) break block12;
                            log.error("Unable to close Object's input stream", e2);
                        }
                    }
                    throw throwable;
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class DownloadObjectRunnable
    extends AbstractRunnable {
        private String objectKey;
        private S3Bucket bucket;
        private DownloadPackage downloadPackage;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private boolean restoreLastModifiedDate;
        private Object result;

        public DownloadObjectRunnable(S3Bucket bucket, String objectKey, DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucket = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        public DownloadObjectRunnable(DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucket = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block36: {
                Exception e222;
                FilterOutputStream bufferedOutputStream;
                BufferedInputStream bufferedInputStream;
                block32: {
                    S3Object object;
                    block31: {
                        bufferedInputStream = null;
                        bufferedOutputStream = null;
                        object = null;
                        if (!this.downloadPackage.isSignedDownload()) {
                            object = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                        } else {
                            SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                            object = handler.getObjectWithSignedUrl(this.downloadPackage.getSignedUrl());
                        }
                        this.interruptableInputStream = new InterruptableInputStream(object.getDataInputStream());
                        bufferedInputStream = new BufferedInputStream(new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor));
                        bufferedOutputStream = new BufferedOutputStream(this.downloadPackage.getOutputStream());
                        try {
                            byte[] buffer = new byte[1024];
                            int byteCount = -1;
                            while ((byteCount = bufferedInputStream.read(buffer)) != -1) {
                                ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                            }
                            Object var7_7 = null;
                            if (bufferedOutputStream == null) break block31;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            if (bufferedOutputStream != null) {
                                bufferedOutputStream.close();
                            }
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                            throw throwable;
                        }
                        bufferedOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    object.setDataInputStream(null);
                    object.setDataInputFile(this.downloadPackage.getDataFile());
                    if (this.restoreLastModifiedDate && this.downloadPackage.getDataFile() != null) {
                        String metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso8601");
                        if (metadataLocalFileDate == null) {
                            metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso860");
                        }
                        if (metadataLocalFileDate != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Restoring original Last Modified date for object '" + object.getKey() + "' to file '" + this.downloadPackage.getDataFile() + "': " + metadataLocalFileDate);
                            }
                            this.downloadPackage.getDataFile().setLastModified(ServiceUtils.parseIso8601Date(metadataLocalFileDate).getTime());
                        }
                    }
                    this.result = object;
                    Object var9_10 = null;
                    if (bufferedInputStream == null) break block32;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception e222) {
                        if (!log.isErrorEnabled()) break block32;
                        log.error("Unable to close Object input stream", e222);
                    }
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Exception e222) {
                        if (log.isErrorEnabled()) {
                            log.error("Unable to close download output stream", e222);
                        }
                    }
                }
                break block36;
                {
                    catch (Throwable t) {
                        Exception e222;
                        block33: {
                            this.result = t;
                            Object var9_11 = null;
                            if (bufferedInputStream != null) {
                                try {
                                    bufferedInputStream.close();
                                }
                                catch (Exception e222) {
                                    if (!log.isErrorEnabled()) break block33;
                                    log.error("Unable to close Object input stream", e222);
                                }
                            }
                        }
                        if (bufferedOutputStream != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Exception e222) {
                                if (log.isErrorEnabled()) {
                                    log.error("Unable to close download output stream", e222);
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block35: {
                        Exception e222;
                        block34: {
                            Object var9_12 = null;
                            if (bufferedInputStream != null) {
                                try {
                                    bufferedInputStream.close();
                                }
                                catch (Exception e222) {
                                    if (!log.isErrorEnabled()) break block34;
                                    log.error("Unable to close Object input stream", e222);
                                }
                            }
                        }
                        if (bufferedOutputStream != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Exception e222) {
                                if (!log.isErrorEnabled()) break block35;
                                log.error("Unable to close download output stream", e222);
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class GetObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private String objectKey;
        private String signedGetOrHeadUrl;
        private boolean headOnly;
        private Object result;

        public GetObjectRunnable(S3Bucket bucket, String objectKey, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.headOnly = headOnly;
        }

        public GetObjectRunnable(String signedGetOrHeadUrl, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = signedGetOrHeadUrl;
            this.bucket = null;
            this.objectKey = null;
            this.headOnly = headOnly;
        }

        public void run() {
            try {
                if (this.headOnly) {
                    if (this.signedGetOrHeadUrl == null) {
                        this.result = S3ServiceMulti.this.s3Service.getObjectDetails(this.bucket, this.objectKey);
                    } else {
                        SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                        this.result = handler.getObjectDetailsWithSignedUrl(this.signedGetOrHeadUrl);
                    }
                } else if (this.signedGetOrHeadUrl == null) {
                    this.result = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    this.result = handler.getObjectWithSignedUrl(this.signedGetOrHeadUrl);
                }
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CopyObjectRunnable
    extends AbstractRunnable {
        private String sourceBucketName;
        private String destinationBucketName;
        private String sourceObjectKey;
        private S3Object destinationObject;
        private boolean replaceMetadata;
        private Object result;

        public CopyObjectRunnable(String sourceBucketName, String destinationBucketName, String sourceObjectKey, S3Object destinationObject, boolean replaceMetadata) {
            this.sourceBucketName = null;
            this.destinationBucketName = null;
            this.sourceObjectKey = null;
            this.destinationObject = null;
            this.replaceMetadata = false;
            this.result = null;
            this.sourceBucketName = sourceBucketName;
            this.destinationBucketName = destinationBucketName;
            this.sourceObjectKey = sourceObjectKey;
            this.destinationObject = destinationObject;
            this.replaceMetadata = replaceMetadata;
        }

        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.copyObject(this.sourceBucketName, this.sourceObjectKey, this.destinationBucketName, this.destinationObject, this.replaceMetadata);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CreateObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private Object result;

        public CreateObjectRunnable(S3Bucket bucket, S3Object s3Object, BytesProgressWatcher progressMonitor) {
            this.bucket = null;
            this.s3Object = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
            this.progressMonitor = progressMonitor;
        }

        public void run() {
            try {
                if (this.s3Object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.s3Object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.s3Object.setDataInputStream(pmInputStream);
                }
                this.result = S3ServiceMulti.this.s3Service.putObject(this.bucket, this.s3Object);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class ListObjectsRunnable
    extends AbstractRunnable {
        private Object result;
        private String bucketName;
        private String prefix;
        private String delimiter;
        private long maxListingLength;
        private String priorLastKey;
        private boolean halted;

        public ListObjectsRunnable(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) {
            this.result = null;
            this.bucketName = null;
            this.prefix = null;
            this.delimiter = null;
            this.maxListingLength = 1000L;
            this.priorLastKey = null;
            this.halted = false;
            this.bucketName = bucketName;
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.maxListingLength = maxListingLength;
            this.priorLastKey = priorLastKey;
        }

        public void run() {
            try {
                ArrayList<S3Object> allObjects = new ArrayList<S3Object>();
                ArrayList<String> allCommonPrefixes = new ArrayList<String>();
                do {
                    S3ObjectsChunk chunk = S3ServiceMulti.this.s3Service.listObjectsChunked(this.bucketName, this.prefix, this.delimiter, this.maxListingLength, this.priorLastKey);
                    this.priorLastKey = chunk.getPriorLastKey();
                    allObjects.addAll(Arrays.asList(chunk.getObjects()));
                    allCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                } while (!this.halted && this.priorLastKey != null);
                this.result = new S3ObjectsChunk(this.prefix, this.delimiter, allObjects.toArray(new S3Object[allObjects.size()]), allCommonPrefixes.toArray(new String[allCommonPrefixes.size()]), null);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            this.halted = true;
        }
    }

    private class CreateBucketRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private Object result;

        public CreateBucketRunnable(S3Bucket bucket) {
            this.bucket = null;
            this.result = null;
            this.bucket = bucket;
        }

        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.createBucket(this.bucket);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class DeleteObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private String signedDeleteUrl;
        private Object result;

        public DeleteObjectRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = null;
            this.bucket = bucket;
            this.object = object;
        }

        public DeleteObjectRunnable(String signedDeleteUrl) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = signedDeleteUrl;
            this.bucket = null;
            this.object = null;
        }

        public void run() {
            try {
                if (this.signedDeleteUrl == null) {
                    S3ServiceMulti.this.s3Service.deleteObject(this.bucket, this.object.getKey());
                    this.result = this.object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    handler.deleteObjectWithSignedUrl(this.signedDeleteUrl);
                    URL url = new URL(this.signedDeleteUrl);
                    this.result = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class GetACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private String signedAclUrl;
        private Object result;

        public GetACLRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.signedAclUrl = null;
            this.result = null;
            this.bucket = bucket;
            this.object = object;
        }

        public GetACLRunnable(String signedAclUrl) {
            this.bucket = null;
            this.object = null;
            this.signedAclUrl = null;
            this.result = null;
            this.signedAclUrl = signedAclUrl;
            this.bucket = null;
            this.object = null;
        }

        public void run() {
            try {
                if (this.signedAclUrl == null) {
                    AccessControlList acl = S3ServiceMulti.this.s3Service.getObjectAcl(this.bucket, this.object.getKey());
                    this.object.setAcl(acl);
                    this.result = this.object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    AccessControlList acl = handler.getObjectAclWithSignedUrl(this.signedAclUrl);
                    URL url = new URL(this.signedAclUrl);
                    this.object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                    this.object.setAcl(acl);
                    this.result = this.object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class PutACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private String signedUrl;
        private AccessControlList signedUrlAcl;
        private Object result;

        public PutACLRunnable(S3Bucket bucket, S3Object s3Object) {
            this.bucket = null;
            this.s3Object = null;
            this.signedUrl = null;
            this.signedUrlAcl = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
        }

        public PutACLRunnable(String signedAclUrl, AccessControlList signedUrlAcl) {
            this.bucket = null;
            this.s3Object = null;
            this.signedUrl = null;
            this.signedUrlAcl = null;
            this.result = null;
            this.signedUrl = signedAclUrl;
            this.signedUrlAcl = signedUrlAcl;
            this.bucket = null;
            this.s3Object = null;
        }

        public void run() {
            try {
                if (this.signedUrl == null) {
                    if (this.s3Object == null) {
                        S3ServiceMulti.this.s3Service.putBucketAcl(this.bucket);
                    } else {
                        S3ServiceMulti.this.s3Service.putObjectAcl(this.bucket, this.s3Object);
                    }
                    this.result = this.s3Object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    handler.putObjectAclWithSignedUrl(this.signedUrl, this.signedUrlAcl);
                    URL url = new URL(this.signedUrl);
                    S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath());
                    object.setAcl(this.signedUrlAcl);
                    this.result = object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private abstract class AbstractRunnable
    implements Runnable {
        private boolean forceInterrupt = false;

        private AbstractRunnable() {
        }

        public abstract Object getResult();

        public abstract void forceInterruptCalled();

        protected void forceInterrupt() {
            this.forceInterrupt = true;
            this.forceInterruptCalled();
        }

        protected boolean notInterrupted() throws InterruptedException {
            if (this.forceInterrupt || Thread.interrupted()) {
                throw new InterruptedException("Interrupted by JAMES");
            }
            return true;
        }
    }
}

