/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.facebook.presto.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;

@InterfaceAudience.Private
public class StorageInfo {
    public int layoutVersion;
    public int namespaceID;
    public String clusterID;
    public long cTime;

    public StorageInfo() {
        this(0, 0, "", 0L);
    }

    public StorageInfo(int layoutV, int nsID, String cid, long cT) {
        this.layoutVersion = layoutV;
        this.clusterID = cid;
        this.namespaceID = nsID;
        this.cTime = cT;
    }

    public StorageInfo(StorageInfo from) {
        this.setStorageInfo(from);
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public int getNamespaceID() {
        return this.namespaceID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public long getCTime() {
        return this.cTime;
    }

    public void setStorageInfo(StorageInfo from) {
        this.layoutVersion = from.layoutVersion;
        this.clusterID = from.clusterID;
        this.namespaceID = from.namespaceID;
        this.cTime = from.cTime;
    }

    public boolean versionSupportsFederation() {
        return LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lv=").append(this.layoutVersion).append(";cid=").append(this.clusterID).append(";nsid=").append(this.namespaceID).append(";c=").append(this.cTime);
        return sb.toString();
    }

    public String toColonSeparatedString() {
        return Joiner.on(":").join(this.layoutVersion, this.namespaceID, this.cTime, this.clusterID);
    }
}

