/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSAdmin
extends FsShell {
    private static final Log LOG;

    public DFSAdmin() {
        this(null);
    }

    public DFSAdmin(Configuration conf) {
        super(conf);
    }

    protected DistributedFileSystem getDFS() throws IOException {
        FileSystem fs = this.getFS();
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
        }
        return (DistributedFileSystem)fs;
    }

    public void report() throws IOException {
        DistributedFileSystem dfs = this.getDFS();
        FsStatus ds = dfs.getStatus();
        long capacity = ds.getCapacity();
        long used = ds.getUsed();
        long remaining = ds.getRemaining();
        long presentCapacity = used + remaining;
        boolean mode = dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
        UpgradeStatusReport status = dfs.distributedUpgradeProgress(HdfsConstants.UpgradeAction.GET_STATUS);
        if (mode) {
            System.out.println("Safe mode is ON");
        }
        if (status != null) {
            System.out.println(status.getStatusText(false));
        }
        System.out.println("Configured Capacity: " + capacity + " (" + StringUtils.byteDesc(capacity) + ")");
        System.out.println("Present Capacity: " + presentCapacity + " (" + StringUtils.byteDesc(presentCapacity) + ")");
        System.out.println("DFS Remaining: " + remaining + " (" + StringUtils.byteDesc(remaining) + ")");
        System.out.println("DFS Used: " + used + " (" + StringUtils.byteDesc(used) + ")");
        System.out.println("DFS Used%: " + StringUtils.formatPercent((double)used / (double)presentCapacity, 2));
        System.out.println("Under replicated blocks: " + dfs.getUnderReplicatedBlocksCount());
        System.out.println("Blocks with corrupt replicas: " + dfs.getCorruptBlocksCount());
        System.out.println("Missing blocks: " + dfs.getMissingBlocksCount());
        System.out.println();
        System.out.println("-------------------------------------------------");
        DatanodeInfo[] live = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo[] dead = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DEAD);
        System.out.println("Datanodes available: " + live.length + " (" + (live.length + dead.length) + " total, " + dead.length + " dead)\n");
        if (live.length > 0) {
            System.out.println("Live datanodes:");
            for (DatanodeInfo dn : live) {
                System.out.println(dn.getDatanodeReport());
                System.out.println();
            }
        }
        if (dead.length > 0) {
            System.out.println("Dead datanodes:");
            for (DatanodeInfo dn : dead) {
                System.out.println(dn.getDatanodeReport());
                System.out.println();
            }
        }
    }

    public void setSafeMode(String[] argv, int idx) throws IOException {
        HdfsConstants.SafeModeAction action;
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        Boolean waitExitSafe = false;
        if ("leave".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
        } else if ("enter".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
        } else if ("get".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_GET;
        } else if ("wait".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_GET;
            waitExitSafe = true;
        } else {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        DistributedFileSystem dfs = this.getDFS();
        boolean inSafeMode = dfs.setSafeMode(action);
        if (waitExitSafe.booleanValue()) {
            while (inSafeMode) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait Interrupted");
                }
                inSafeMode = dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
            }
        }
        System.out.println("Safe mode is " + (inSafeMode ? "ON" : "OFF"));
    }

    public int saveNamespace() throws IOException {
        int exitCode = -1;
        DistributedFileSystem dfs = this.getDFS();
        dfs.saveNamespace();
        exitCode = 0;
        return exitCode;
    }

    public int rollEdits() throws IOException {
        DistributedFileSystem dfs = this.getDFS();
        long txid = dfs.rollEdits();
        System.out.println("Successfully rolled edit logs.");
        System.out.println("New segment starts at txid " + txid);
        return 0;
    }

    public int restoreFaileStorage(String arg) throws IOException {
        int exitCode = -1;
        if (!(arg.equals("check") || arg.equals("true") || arg.equals("false"))) {
            System.err.println("restoreFailedStorage valid args are true|false|check");
            return exitCode;
        }
        DistributedFileSystem dfs = this.getDFS();
        Boolean res = dfs.restoreFailedStorage(arg);
        System.out.println("restoreFailedStorage is set to " + res);
        exitCode = 0;
        return exitCode;
    }

    public int refreshNodes() throws IOException {
        int exitCode = -1;
        DistributedFileSystem dfs = this.getDFS();
        dfs.refreshNodes();
        exitCode = 0;
        return exitCode;
    }

    public int setBalancerBandwidth(String[] argv, int idx) throws IOException {
        long bandwidth;
        int exitCode = -1;
        try {
            bandwidth = Long.parseLong(argv[idx]);
        }
        catch (NumberFormatException nfe) {
            System.err.println("NumberFormatException: " + nfe.getMessage());
            System.err.println("Usage: java DFSAdmin [-setBalancerBandwidth <bandwidth in bytes per second>]");
            return exitCode;
        }
        FileSystem fs = this.getFS();
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        dfs.setBalancerBandwidth(bandwidth);
        exitCode = 0;
        return exitCode;
    }

    public int fetchImage(final String[] argv, final int idx) throws IOException {
        final String infoServer = DFSUtil.getInfoServer(HAUtil.getAddressOfActive(this.getDFS()), this.getConf(), false);
        SecurityUtil.doAsCurrentUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TransferFsImage.downloadMostRecentImageToDirectory(infoServer, new File(argv[idx]));
                return null;
            }
        });
        return 0;
    }

    private void printHelp(String cmd) {
        String summary = "hadoop dfsadmin is the command to execute DFS administrative commands.\nThe full syntax is: \n\nhadoop dfsadmin [-report] [-safemode <enter | leave | get | wait>]\n\t[-saveNamespace]\n\t[-rollEdits]\n\t[-restoreFailedStorage true|false|check]\n\t[-refreshNodes]\n\t[-setQuota <quota> <dirname>...<dirname>]\n\t[-clrQuota <dirname>...<dirname>]\n\t[-setSpaceQuota <quota> <dirname>...<dirname>]\n\t[-clrSpaceQuota <dirname>...<dirname>]\n\t[-refreshServiceAcl]\n\t[-refreshUserToGroupsMappings]\n\t[refreshSuperUserGroupsConfiguration]\n\t[-printTopology]\n\t[-refreshNamenodes datanodehost:port]\n\t[-deleteBlockPool datanodehost:port blockpoolId [force]]\n\t[-setBalancerBandwidth <bandwidth>]\n\t[-fetchImage <local directory>]\n\t[-help [cmd]]\n";
        String report = "-report: \tReports basic filesystem information and statistics.\n";
        String safemode = "-safemode <enter|leave|get|wait>:  Safe mode maintenance command.\n\t\tSafe mode is a Namenode state in which it\n\t\t\t1.  does not accept changes to the name space (read-only)\n\t\t\t2.  does not replicate or delete blocks.\n\t\tSafe mode is entered automatically at Namenode startup, and\n\t\tleaves safe mode automatically when the configured minimum\n\t\tpercentage of blocks satisfies the minimum replication\n\t\tcondition.  Safe mode can also be entered manually, but then\n\t\tit can only be turned off manually as well.\n";
        String saveNamespace = "-saveNamespace:\tSave current namespace into storage directories and reset edits log.\n\t\tRequires superuser permissions and safe mode.\n";
        String rollEdits = "-rollEdits:\tRolls the edit log.\n\t\tRequires superuser permissions.\n";
        String restoreFailedStorage = "-restoreFailedStorage:\tSet/Unset/Check flag to attempt restore of failed storage replicas if they become available.\n\t\tRequires superuser permissions.\n";
        String refreshNodes = "-refreshNodes: \tUpdates the namenode with the set of datanodes allowed to connect to the namenode.\n\n\t\tNamenode re-reads datanode hostnames from the file defined by \n\t\tdfs.hosts, dfs.hosts.exclude configuration parameters.\n\t\tHosts defined in dfs.hosts are the datanodes that are part of \n\t\tthe cluster. If there are entries in dfs.hosts, only the hosts \n\t\tin it are allowed to register with the namenode.\n\n\t\tEntries in dfs.hosts.exclude are datanodes that need to be \n\t\tdecommissioned. Datanodes complete decommissioning when \n\t\tall the replicas from them are replicated to other datanodes.\n\t\tDecommissioned nodes are not automatically shutdown and \n\t\tare not chosen for writing new replicas.\n";
        String finalizeUpgrade = "-finalizeUpgrade: Finalize upgrade of HDFS.\n\t\tDatanodes delete their previous version working directories,\n\t\tfollowed by Namenode doing the same.\n\t\tThis completes the upgrade process.\n";
        String upgradeProgress = "-upgradeProgress <status|details|force>: \n\t\trequest current distributed upgrade status, \n\t\ta detailed status or force the upgrade to proceed.\n";
        String metaSave = "-metasave <filename>: \tSave Namenode's primary data structures\n\t\tto <filename> in the directory specified by hadoop.log.dir property.\n\t\t<filename> will contain one line for each of the following\n\t\t\t1. Datanodes heart beating with Namenode\n\t\t\t2. Blocks waiting to be replicated\n\t\t\t3. Blocks currrently being replicated\n\t\t\t4. Blocks waiting to be deleted\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tNamenode will reload the authorization policy file.\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshSuperUserGroupsConfiguration = "-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings\n";
        String printTopology = "-printTopology: Print a tree of the racks and their\n\t\tnodes as reported by the Namenode\n";
        String refreshNamenodes = "-refreshNamenodes: Takes a datanodehost:port as argument,\n\t\tFor the given datanode, reloads the configuration files,\n\t\tstops serving the removed block-pools\n\t\tand starts serving new block-pools\n";
        String deleteBlockPool = "-deleteBlockPool: Arguments are datanodehost:port, blockpool id\n\t\t and an optional argument \"force\". If force is passed,\n\t\t block pool directory for the given blockpool id on the given\n\t\t datanode is deleted along with its contents, otherwise\n\t\t the directory is deleted only if it is empty. The command\n\t\t will fail if datanode is still serving the block pool.\n\t\t   Refer to refreshNamenodes to shutdown a block pool\n\t\t service on a datanode.\n";
        String setBalancerBandwidth = "-setBalancerBandwidth <bandwidth>:\n\tChanges the network bandwidth used by each datanode during\n\tHDFS block balancing.\n\n\t\t<bandwidth> is the maximum number of bytes per second\n\t\tthat will be used by each datanode. This value overrides\n\t\tthe dfs.balance.bandwidthPerSec parameter.\n\n\t\t--- NOTE: The new value is not persistent on the DataNode.---\n";
        String fetchImage = "-fetchImage <local directory>:\n\tDownloads the most recent fsimage from the Name Node and saves it in\tthe specified local directory.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("report".equals(cmd)) {
            System.out.println(report);
        } else if ("safemode".equals(cmd)) {
            System.out.println(safemode);
        } else if ("saveNamespace".equals(cmd)) {
            System.out.println(saveNamespace);
        } else if ("rollEdits".equals(cmd)) {
            System.out.println(rollEdits);
        } else if ("restoreFailedStorage".equals(cmd)) {
            System.out.println(restoreFailedStorage);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("finalizeUpgrade".equals(cmd)) {
            System.out.println(finalizeUpgrade);
        } else if ("upgradeProgress".equals(cmd)) {
            System.out.println(upgradeProgress);
        } else if ("metasave".equals(cmd)) {
            System.out.println(metaSave);
        } else if (SetQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n");
        } else if (ClearQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if (SetSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
        } else if (ClearSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.out.println(refreshSuperUserGroupsConfiguration);
        } else if ("printTopology".equals(cmd)) {
            System.out.println(printTopology);
        } else if ("refreshNamenodes".equals(cmd)) {
            System.out.println(refreshNamenodes);
        } else if ("deleteBlockPool".equals(cmd)) {
            System.out.println(deleteBlockPool);
        } else if ("setBalancerBandwidth".equals(cmd)) {
            System.out.println(setBalancerBandwidth);
        } else if ("fetchImage".equals(cmd)) {
            System.out.println(fetchImage);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(report);
            System.out.println(safemode);
            System.out.println(saveNamespace);
            System.out.println(rollEdits);
            System.out.println(restoreFailedStorage);
            System.out.println(refreshNodes);
            System.out.println(finalizeUpgrade);
            System.out.println(upgradeProgress);
            System.out.println(metaSave);
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n");
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println("-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n");
            System.out.println("-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println(refreshServiceAcl);
            System.out.println(refreshUserToGroupsMappings);
            System.out.println(refreshSuperUserGroupsConfiguration);
            System.out.println(printTopology);
            System.out.println(refreshNamenodes);
            System.out.println(deleteBlockPool);
            System.out.println(setBalancerBandwidth);
            System.out.println(fetchImage);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    public int finalizeUpgrade() throws IOException {
        DistributedFileSystem dfs = this.getDFS();
        dfs.finalizeUpgrade();
        return 0;
    }

    public int upgradeProgress(String[] argv, int idx) throws IOException {
        HdfsConstants.UpgradeAction action;
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        if ("status".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.UpgradeAction.GET_STATUS;
        } else if ("details".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.UpgradeAction.DETAILED_STATUS;
        } else if ("force".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.UpgradeAction.FORCE_PROCEED;
        } else {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        DistributedFileSystem dfs = this.getDFS();
        UpgradeStatusReport status = dfs.distributedUpgradeProgress(action);
        String statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(action == HdfsConstants.UpgradeAction.DETAILED_STATUS);
        System.out.println(statusText);
        return 0;
    }

    public int metaSave(String[] argv, int idx) throws IOException {
        String pathname = argv[idx];
        DistributedFileSystem dfs = this.getDFS();
        dfs.metaSave(pathname);
        System.out.println("Created metasave file " + pathname + " in the log " + "directory of namenode " + dfs.getUri());
        return 0;
    }

    public int printTopology() throws IOException {
        DistributedFileSystem dfs = this.getDFS();
        DatanodeInfo[] report = dfs.getDataNodeStats();
        HashMap tree = new HashMap();
        for (DatanodeInfo dni : report) {
            String location = dni.getNetworkLocation();
            String name = dni.getName();
            if (!tree.containsKey(location)) {
                tree.put(location, new TreeSet());
            }
            ((TreeSet)tree.get(location)).add(name);
        }
        ArrayList racks = new ArrayList(tree.keySet());
        Collections.sort(racks);
        for (String r : racks) {
            System.out.println("Rack: " + r);
            TreeSet nodes = (TreeSet)tree.get(r);
            for (String n : nodes) {
                System.out.print("   " + n);
                String hostname = NetUtils.getHostNameOfIP(n);
                if (hostname != null) {
                    System.out.print(" (" + hostname + ")");
                }
                System.out.println();
            }
            System.out.println();
        }
        return 0;
    }

    private static UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    public int refreshServiceAcl() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshAuthorizationPolicyProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri(conf), RefreshAuthorizationPolicyProtocol.class).getProxy();
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    public int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri(conf), RefreshUserMappingsProtocol.class).getProxy();
        refreshProtocol.refreshUserToGroupsMappings();
        return 0;
    }

    public int refreshSuperUserGroupsConfiguration() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri(conf), RefreshUserMappingsProtocol.class).getProxy();
        refreshProtocol.refreshSuperUserGroupsConfiguration();
        return 0;
    }

    private static void printUsage(String cmd) {
        if ("-report".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-report]");
        } else if ("-safemode".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-safemode enter | leave | get | wait]");
        } else if ("-saveNamespace".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-saveNamespace]");
        } else if ("-rollEdits".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-rollEdits]");
        } else if ("-restoreFailedStorage".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-restoreFailedStorage true|false|check ]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshNodes]");
        } else if ("-finalizeUpgrade".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-finalizeUpgrade]");
        } else if ("-upgradeProgress".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-upgradeProgress status | details | force]");
        } else if ("-metasave".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-metasave filename]");
        } else if (SetQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setQuota <quota> <dirname>...<dirname>]");
        } else if (ClearQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-clrQuota <dirname>...<dirname>]");
        } else if (SetSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setSpaceQuota <quota> <dirname>...<dirname>]");
        } else if (ClearSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-clrSpaceQuota <dirname>...<dirname>]");
        } else if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshServiceAcl]");
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshSuperUserGroupsConfiguration]");
        } else if ("-printTopology".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-printTopology]");
        } else if ("-refreshNamenodes".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshNamenodes datanode-host:port]");
        } else if ("-deleteBlockPool".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-deleteBlockPool datanode-host:port blockpoolId [force]]");
        } else if ("-setBalancerBandwidth".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setBalancerBandwidth <bandwidth in bytes per second>]");
        } else if ("-fetchImage".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-fetchImage <local directory>]");
        } else {
            System.err.println("Usage: java DFSAdmin");
            System.err.println("Note: Administrative commands can only be run as the HDFS superuser.");
            System.err.println("           [-report]");
            System.err.println("           [-safemode enter | leave | get | wait]");
            System.err.println("           [-saveNamespace]");
            System.err.println("           [-rollEdits]");
            System.err.println("           [-restoreFailedStorage true|false|check]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-finalizeUpgrade]");
            System.err.println("           [-upgradeProgress status | details | force]");
            System.err.println("           [-metasave filename]");
            System.err.println("           [-refreshServiceAcl]");
            System.err.println("           [-refreshUserToGroupsMappings]");
            System.err.println("           [-refreshSuperUserGroupsConfiguration]");
            System.err.println("           [-printTopology]");
            System.err.println("           [-refreshNamenodes datanodehost:port]");
            System.err.println("           [-deleteBlockPool datanode-host:port blockpoolId [force]]");
            System.err.println("           [-setQuota <quota> <dirname>...<dirname>]");
            System.err.println("           [-clrQuota <dirname>...<dirname>]");
            System.err.println("           [-setSpaceQuota <quota> <dirname>...<dirname>]");
            System.err.println("           [-clrSpaceQuota <dirname>...<dirname>]");
            System.err.println("           [-setBalancerBandwidth <bandwidth in bytes per second>]");
            System.err.println("           [-fetchImage <local directory>]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            DFSAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-safemode".equals(cmd = argv[i++])) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-report".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-saveNamespace".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-rollEdits".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-restoreFailedStorage".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNodes".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-finalizeUpgrade".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-upgradeProgress".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-metasave".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshServiceAcl".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-printTopology".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNamenodes".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-deleteBlockPool".equals(cmd)) {
            if (argv.length != 3 && argv.length != 4) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-setBalancerBandwidth".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-fetchImage".equals(cmd) && argv.length != 2) {
            DFSAdmin.printUsage(cmd);
            return exitCode;
        }
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to DFS... command aborted.");
            return exitCode;
        }
        Exception debugException = null;
        exitCode = 0;
        try {
            if ("-report".equals(cmd)) {
                this.report();
            } else if ("-safemode".equals(cmd)) {
                this.setSafeMode(argv, i);
            } else if ("-saveNamespace".equals(cmd)) {
                exitCode = this.saveNamespace();
            } else if ("-rollEdits".equals(cmd)) {
                exitCode = this.rollEdits();
            } else if ("-restoreFailedStorage".equals(cmd)) {
                exitCode = this.restoreFaileStorage(argv[i]);
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-finalizeUpgrade".equals(cmd)) {
                exitCode = this.finalizeUpgrade();
            } else if ("-upgradeProgress".equals(cmd)) {
                exitCode = this.upgradeProgress(argv, i);
            } else if ("-metasave".equals(cmd)) {
                exitCode = this.metaSave(argv, i);
            } else if (ClearQuotaCommand.matches(cmd)) {
                exitCode = new ClearQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (SetQuotaCommand.matches(cmd)) {
                exitCode = new SetQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (ClearSpaceQuotaCommand.matches(cmd)) {
                exitCode = new ClearSpaceQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (SetSpaceQuotaCommand.matches(cmd)) {
                exitCode = new SetSpaceQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcl();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-printTopology".equals(cmd)) {
                exitCode = this.printTopology();
            } else if ("-refreshNamenodes".equals(cmd)) {
                exitCode = this.refreshNamenodes(argv, i);
            } else if ("-deleteBlockPool".equals(cmd)) {
                exitCode = this.deleteBlockPool(argv, i);
            } else if ("-setBalancerBandwidth".equals(cmd)) {
                exitCode = this.setBalancerBandwidth(argv, i);
            } else if ("-fetchImage".equals(cmd)) {
                exitCode = this.fetchImage(argv, i);
            } else if ("-help".equals(cmd)) {
                if (i < argv.length) {
                    this.printHelp(argv[i]);
                } else {
                    this.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                DFSAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            debugException = arge;
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            DFSAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            debugException = e;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                debugException = ex;
            }
        }
        catch (Exception e) {
            exitCode = -1;
            debugException = e;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception encountered:", debugException);
        }
        return exitCode;
    }

    private ClientDatanodeProtocol getDataNodeProxy(String datanode) throws IOException {
        InetSocketAddress datanodeAddr = NetUtils.createSocketAddr(datanode);
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.datanode.kerberos.principal", ""));
        ClientDatanodeProtocol dnProtocol = DFSUtil.createClientDatanodeProtocolProxy(datanodeAddr, DFSAdmin.getUGI(), conf, NetUtils.getSocketFactory(conf, ClientDatanodeProtocol.class));
        return dnProtocol;
    }

    private int deleteBlockPool(String[] argv, int i) throws IOException {
        ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(argv[i]);
        boolean force = false;
        if (argv.length - 1 == i + 2) {
            if ("force".equals(argv[i + 2])) {
                force = true;
            } else {
                DFSAdmin.printUsage("-deleteBlockPool");
                return -1;
            }
        }
        dnProxy.deleteBlockPool(argv[i + 1], force);
        return 0;
    }

    private int refreshNamenodes(String[] argv, int i) throws IOException {
        String datanode = argv[i];
        ClientDatanodeProtocol refreshProtocol = this.getDataNodeProxy(datanode);
        refreshProtocol.refreshNamenodes();
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new DFSAdmin(), argv);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
        LOG = LogFactory.getLog(DFSAdmin.class);
    }

    private static class SetSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setSpaceQuota";
        private static final String USAGE = "-setSpaceQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setSpaceQuota <quota> <dirname>...<dirname>: Set the disk space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be speciefied with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n";
        private long quota;

        SetSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            String str = parameters.remove(0).trim();
            try {
                this.quota = StringUtils.TraditionalBinaryPrefix.string2long(str);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("\"" + str + "\" is not a valid value for a quota.");
            }
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setSpaceQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, Long.MAX_VALUE, this.quota);
        }
    }

    private static class ClearSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrSpaceQuota";
        private static final String USAGE = "-clrSpaceQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrSpaceQuota <dirname>...<dirname>: Clear the disk space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrSpaceQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, Long.MAX_VALUE, -1L);
        }
    }

    private static class SetQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setQuota";
        private static final String USAGE = "-setQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n";
        private final long quota;

        SetQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.quota = Long.parseLong(parameters.remove(0));
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, this.quota, Long.MAX_VALUE);
        }
    }

    private static class ClearQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrQuota";
        private static final String USAGE = "-clrQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrQuota".equals(cmd);
        }

        @Override
        public String getCommandName() {
            return NAME;
        }

        @Override
        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, -1L, Long.MAX_VALUE);
        }
    }

    private static abstract class DFSAdminCommand
    extends Command {
        final DistributedFileSystem dfs;

        public DFSAdminCommand(FileSystem fs) {
            super(fs.getConf());
            if (!(fs instanceof DistributedFileSystem)) {
                throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
            }
            this.dfs = (DistributedFileSystem)fs;
        }
    }
}

