/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.facebook.presto.hadoop.shaded.org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailed;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFailedEvent
implements HistoryEvent {
    private TaskFailed datum = new TaskFailed();

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt) {
        this.datum.taskid = new Utf8(id.toString());
        this.datum.error = new Utf8(error);
        this.datum.finishTime = finishTime;
        this.datum.taskType = new Utf8(taskType.name());
        this.datum.failedDueToAttempt = failedDueToAttempt == null ? null : new Utf8(failedDueToAttempt.toString());
        this.datum.status = new Utf8(status);
    }

    TaskFailedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskFailed)datum;
    }

    public TaskID getTaskId() {
        return TaskID.forName(((Object)this.datum.taskid).toString());
    }

    public String getError() {
        return ((Object)this.datum.error).toString();
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(((Object)this.datum.taskType).toString());
    }

    public TaskAttemptID getFailedAttemptID() {
        return this.datum.failedDueToAttempt == null ? null : TaskAttemptID.forName(((Object)this.datum.failedDueToAttempt).toString());
    }

    public String getTaskStatus() {
        return ((Object)this.datum.status).toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FAILED;
    }
}

