/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;

class EventFetcher<K, V>
extends Thread {
    private static final long SLEEP_TIME = 1000L;
    private static final int MAX_RETRIES = 10;
    private static final int RETRY_PERIOD = 5000;
    private static final Log LOG = LogFactory.getLog(EventFetcher.class);
    private final TaskAttemptID reduce;
    private final TaskUmbilicalProtocol umbilical;
    private final ShuffleScheduler<K, V> scheduler;
    private int fromEventIdx = 0;
    private int maxEventsToFetch;
    private ExceptionReporter exceptionReporter = null;
    private int maxMapRuntime = 0;
    private volatile boolean stopped = false;

    public EventFetcher(TaskAttemptID reduce, TaskUmbilicalProtocol umbilical, ShuffleScheduler<K, V> scheduler, ExceptionReporter reporter, int maxEventsToFetch) {
        this.setName("EventFetcher for fetching Map Completion Events");
        this.setDaemon(true);
        this.reduce = reduce;
        this.umbilical = umbilical;
        this.scheduler = scheduler;
        this.exceptionReporter = reporter;
        this.maxEventsToFetch = maxEventsToFetch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int failures = 0;
        LOG.info(this.reduce + " Thread started: " + this.getName());
        try {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                try {
                    int numNewMaps = this.getMapCompletionEvents();
                    failures = 0;
                    if (numNewMaps > 0) {
                        LOG.info(this.reduce + ": " + "Got " + numNewMaps + " new map-outputs");
                    }
                    LOG.debug("GetMapEventsThread about to sleep for 1000");
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info("EventFetcher is interrupted.. Returning");
                    return;
                }
                catch (IOException ie) {
                    LOG.info("Exception in getting events", ie);
                    if (++failures >= 10) {
                        throw new IOException("too many failures downloading events", ie);
                    }
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(5000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
            return;
        }
    }

    public void shutDown() {
        this.stopped = true;
        this.interrupt();
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn("Got interrupted while joining " + this.getName(), ie);
        }
    }

    protected int getMapCompletionEvents() throws IOException {
        int numNewMaps = 0;
        TaskCompletionEvent[] events = null;
        do {
            MapTaskCompletionEventsUpdate update = this.umbilical.getMapCompletionEvents((JobID)this.reduce.getJobID(), this.fromEventIdx, this.maxEventsToFetch, (org.apache.hadoop.mapred.TaskAttemptID)this.reduce);
            events = update.getMapTaskCompletionEvents();
            LOG.debug("Got " + events.length + " map completion events from " + this.fromEventIdx);
            if (update.shouldReset()) {
                this.fromEventIdx = 0;
                this.scheduler.resetKnownMaps();
            }
            this.fromEventIdx += events.length;
            block6: for (TaskCompletionEvent event : events) {
                switch (event.getTaskStatus()) {
                    case SUCCEEDED: {
                        URI u = this.getBaseURI(event.getTaskTrackerHttp());
                        this.scheduler.addKnownMapOutput(u.getHost() + ":" + u.getPort(), u.toString(), event.getTaskAttemptId());
                        ++numNewMaps;
                        int duration = event.getTaskRunTime();
                        if (duration <= this.maxMapRuntime) continue block6;
                        this.maxMapRuntime = duration;
                        this.scheduler.informMaxMapRunTime(this.maxMapRuntime);
                        continue block6;
                    }
                    case FAILED: 
                    case KILLED: 
                    case OBSOLETE: {
                        this.scheduler.obsoleteMapOutput(event.getTaskAttemptId());
                        LOG.info("Ignoring obsolete output of " + (Object)((Object)event.getTaskStatus()) + " map-task: '" + event.getTaskAttemptId() + "'");
                        continue block6;
                    }
                    case TIPFAILED: {
                        this.scheduler.tipFailed(event.getTaskAttemptId().getTaskID());
                        LOG.info("Ignoring output of failed map TIP: '" + event.getTaskAttemptId() + "'");
                    }
                }
            }
        } while (events.length == this.maxEventsToFetch);
        return numNewMaps;
    }

    private URI getBaseURI(String url) {
        StringBuffer baseUrl = new StringBuffer(url);
        if (!url.endsWith("/")) {
            baseUrl.append("/");
        }
        baseUrl.append("mapOutput?job=");
        baseUrl.append(this.reduce.getJobID());
        baseUrl.append("&reduce=");
        baseUrl.append(this.reduce.getTaskID().getId());
        baseUrl.append("&map=");
        URI u = URI.create(baseUrl.toString());
        return u;
    }
}

