/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

class ChildAggregatedMemoryContext
extends AggregatedMemoryContext {
    private final AggregatedMemoryContext parentMemoryContext;

    ChildAggregatedMemoryContext(AggregatedMemoryContext parentMemoryContext) {
        this.parentMemoryContext = Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    @Override
    synchronized ListenableFuture<?> updateBytes(long bytes) {
        ListenableFuture<?> future = this.parentMemoryContext.updateBytes(bytes);
        this.addBytes(bytes);
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(long delta) {
        if (this.parentMemoryContext.tryUpdateBytes(delta)) {
            this.addBytes(delta);
            return true;
        }
        return false;
    }

    @Override
    synchronized AggregatedMemoryContext getParent() {
        return this.parentMemoryContext;
    }

    @Override
    void closeContext() {
        this.parentMemoryContext.updateBytes(-this.getBytes());
    }
}

