/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.brush;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.function.mask.ImageBrushMask;
import com.fastasyncworldedit.core.function.mask.SurfaceMask;
import com.fastasyncworldedit.core.util.TextureUtil;
import com.fastasyncworldedit.core.util.collection.SummedColorTable;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class ImageBrush
implements Brush {
    private final LocalSession session;
    private final SummedColorTable table;
    private final int width;
    private final int height;
    private final double centerImageX;
    private final double centerImageZ;
    private final ColorFunction colorFunction;

    public ImageBrush(BufferedImage image, LocalSession session, boolean alpha) {
        this.session = session;
        this.table = new SummedColorTable(image, alpha);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.centerImageX = (double)this.width / 2.0;
        this.centerImageZ = (double)this.height / 2.0;
        this.colorFunction = alpha ? (x1, z1, x2, z2, extent, pos) -> {
            int color = this.table.averageRGBA(x1, z1, x2, z2);
            int alpha1 = color >> 24 & 0xFF;
            switch (alpha1) {
                case 0: {
                    return 0;
                }
                case 255: {
                    return color;
                }
            }
            BlockState block = extent.getBlock(pos);
            TextureUtil tu = session.getTextureUtil();
            BlockType type = block.getBlockType();
            int existingColor = type == BlockTypes.GRASS_BLOCK ? tu.getColor(extent.getBiome(pos)) : tu.getColor(type);
            return TextureUtil.combineTransparency(color, existingColor);
        } : (x1, z1, x2, z2, extent, pos) -> this.table.averageRGB(x1, z1, x2, z2);
    }

    @Override
    public void build(EditSession editSession, BlockVector3 center, Pattern pattern, double sizeDouble) throws MaxChangedBlocksException {
        SurfaceMask solid = new SurfaceMask(editSession);
        double scale = (double)Math.max(this.width, this.height) / sizeDouble;
        Actor actor = editSession.getActor();
        if (!(actor instanceof Player)) {
            throw FaweCache.PLAYER_ONLY;
        }
        Player player = (Player)actor;
        Location loc = player.getLocation();
        float yaw = loc.getYaw();
        float pitch = loc.getPitch();
        AffineTransform transform = new AffineTransform().rotateY(-yaw % 360.0f).rotateX((pitch - 90.0f) % 360.0f).inverse();
        RecursiveVisitor visitor = new RecursiveVisitor(new ImageBrushMask(solid, center, transform, scale, this.centerImageX, this.centerImageZ, this.width, this.height, this.colorFunction, editSession, this.session.getTextureUtil()), vector -> true, Integer.MAX_VALUE, editSession.getMinY(), editSession.getMaxY());
        visitor.setDirections(Arrays.asList(BreadthFirstSearch.DIAGONAL_DIRECTIONS));
        visitor.visit(center);
        Operations.completeBlindly(visitor);
    }

    public static interface ColorFunction {
        public int call(int var1, int var2, int var3, int var4, Extent var5, BlockVector3 var6);
    }
}

