/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.brush;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.math.LocalBlockVectorSet;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.interpolation.KochanekBartelsInterpolation;
import com.sk89q.worldedit.math.interpolation.Node;
import com.sk89q.worldedit.util.formatting.text.Component;
import java.util.ArrayList;

public class SurfaceSpline
implements Brush {
    private final double tension;
    private final double bias;
    private final double continuity;
    private final double quality;
    private final ArrayList<BlockVector3> path = new ArrayList();

    public SurfaceSpline(double tension, double bias, double continuity, double quality) {
        this.tension = tension;
        this.bias = bias;
        this.continuity = continuity;
        this.quality = quality;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 pos, Pattern pattern, double radius) throws MaxChangedBlocksException {
        int maxY = editSession.getMaxY();
        int minY = editSession.getMinY();
        if (this.path.isEmpty() || !pos.equals(this.path.get(this.path.size() - 1))) {
            int max = editSession.getNearestSurfaceTerrainBlock(pos.getBlockX(), pos.getBlockZ(), pos.getBlockY(), minY, maxY);
            if (max == -1) {
                return;
            }
            this.path.add(BlockVector3.at(pos.getBlockX(), max, pos.getBlockZ()));
            if (editSession.getActor() != null) {
                editSession.getActor().print((Component)Caption.of("fawe.worldedit.brush.spline.primary.2", new Object[0]));
            }
            return;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.path.size());
        KochanekBartelsInterpolation interpol = new KochanekBartelsInterpolation();
        for (BlockVector3 nodevector : this.path) {
            Node n = new Node(nodevector.toVector3());
            n.setTension(this.tension);
            n.setBias(this.bias);
            n.setContinuity(this.continuity);
            nodes.add(n);
        }
        MutableBlockVector3 mutable = MutableBlockVector3.at(0, 0, 0);
        interpol.setNodes(nodes);
        double splinelength = interpol.arcLength(0.0, 1.0);
        LocalBlockVectorSet vset = new LocalBlockVectorSet();
        for (double loop = 0.0; loop <= 1.0; loop += 1.0 / splinelength / this.quality) {
            Vector3 tipv = interpol.getPosition(loop);
            int tipx = MathMan.roundInt(tipv.getX());
            int tipz = (int)tipv.getZ();
            int tipy = MathMan.roundInt(tipv.getY());
            if ((tipy = editSession.getNearestSurfaceTerrainBlock(tipx, tipz, tipy, minY, maxY, Integer.MIN_VALUE, Integer.MAX_VALUE)) == Integer.MIN_VALUE || tipy == Integer.MAX_VALUE) continue;
            if (radius == 0.0) {
                MutableBlockVector3 set = mutable.setComponents(tipx, tipy, tipz);
                pattern.apply(editSession, set, set);
                continue;
            }
            vset.add(tipx, tipy, tipz);
        }
        if (radius != 0.0) {
            double radius2 = radius * radius;
            LocalBlockVectorSet newSet = new LocalBlockVectorSet();
            int ceilrad = (int)Math.ceil(radius);
            for (BlockVector3 v : vset) {
                int tipx = v.getBlockX();
                int tipz = v.getBlockZ();
                for (int loopx = tipx - ceilrad; loopx <= tipx + ceilrad; ++loopx) {
                    for (int loopz = tipz - ceilrad; loopz <= tipz + ceilrad; ++loopz) {
                        int y;
                        if (!(MathMan.hypot2(loopx - tipx, 0.0, loopz - tipz) <= radius2) || (y = editSession.getNearestSurfaceTerrainBlock(loopx, loopz, v.getBlockY(), minY, maxY, Integer.MIN_VALUE, Integer.MAX_VALUE)) == Integer.MIN_VALUE || y == Integer.MAX_VALUE) continue;
                        newSet.add(loopx, y, loopz);
                    }
                }
            }
            editSession.setBlocks(newSet, pattern);
        }
        this.path.clear();
        if (editSession.getActor() != null) {
            editSession.getActor().print((Component)Caption.of("fawe.worldedit.brush.spline.secondary", new Object[0]));
        }
    }
}

