/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import org.jetbrains.annotations.NotNull;

public class ReentrantWrappedStampedLock
implements Lock {
    private final StampedLock parent = new StampedLock();
    private volatile Thread owner;
    private volatile long stamp = 0L;

    @Override
    public void lock() {
        if (Thread.currentThread() == this.owner) {
            return;
        }
        this.stamp = this.parent.writeLock();
        this.owner = Thread.currentThread();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (Thread.currentThread() == this.owner) {
            return;
        }
        this.stamp = this.parent.writeLockInterruptibly();
        this.owner = Thread.currentThread();
    }

    @Override
    public boolean tryLock() {
        if (Thread.currentThread() == this.owner) {
            return true;
        }
        if (this.parent.isWriteLocked()) {
            return false;
        }
        this.stamp = this.parent.writeLock();
        this.owner = Thread.currentThread();
        return true;
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        if (Thread.currentThread() == this.owner) {
            return true;
        }
        if (!this.parent.isWriteLocked()) {
            this.stamp = this.parent.writeLock();
            this.owner = Thread.currentThread();
            return true;
        }
        this.stamp = this.parent.tryWriteLock(time, unit);
        this.owner = Thread.currentThread();
        return false;
    }

    @Override
    public void unlock() {
        if (this.owner != Thread.currentThread()) {
            throw new IllegalCallerException("The lock should only be unlocked by the owning thread when a stamp is not supplied");
        }
        this.unlock(this.stamp);
    }

    @Override
    @NotNull
    public Condition newCondition() {
        throw new UnsupportedOperationException("Conditions are not supported by StampedLock");
    }

    public long getStampChecked() {
        if (this.stamp != 0L && this.owner != Thread.currentThread()) {
            throw new IllegalCallerException("The stamp should be be acquired by a thread that does not own the lock");
        }
        return this.stamp;
    }

    public void unlock(long stamp) {
        this.parent.unlockWrite(stamp);
        this.stamp = 0L;
        this.owner = null;
    }

    public boolean isLocked() {
        return this.owner == null && this.stamp == 0L && this.parent.isWriteLocked();
    }
}

