/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser.mask;

import com.fastasyncworldedit.core.command.SuggestInputParseException;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.FaweParser;
import com.fastasyncworldedit.core.function.mask.BlockMaskBuilder;
import com.fastasyncworldedit.core.function.mask.MaskUnion;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.MemoizingValueAccess;
import org.enginehub.piston.suggestion.Suggestion;

public class RichMaskParser
extends FaweParser<Mask> {
    public RichMaskParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public Mask parseFromInput(String input, ParserContext context) throws InputParseException {
        if (input.isEmpty()) {
            throw new SuggestInputParseException("No input provided", "", () -> Stream.of("#", ",", "&").map(n -> n + ":").collect(Collectors.toList()));
        }
        Extent extent = context.getExtent();
        if (extent == null) {
            extent = Request.request().getExtent();
        }
        ArrayList masks = new ArrayList();
        masks.add(new ArrayList());
        CommandLocals locals = new CommandLocals();
        Actor actor = context.getActor();
        if (actor != null) {
            locals.put(Actor.class, actor);
        }
        try {
            List<Map.Entry<FaweParser.ParseEntry, List<String>>> parsed = RichMaskParser.parse(input);
            for (Map.Entry<FaweParser.ParseEntry, List<String>> entry : parsed) {
                FaweParser.ParseEntry pe = entry.getKey();
                String command = pe.getInput();
                String full = pe.getFull();
                Mask mask = null;
                if (command.isEmpty()) {
                    mask = this.parseFromInput(StringMan.join((Collection)entry.getValue(), ','), context);
                } else if (!this.worldEdit.getMaskFactory().containsAlias(command)) {
                    boolean charMask;
                    char char0 = command.charAt(0);
                    boolean bl = charMask = input.length() > 1 && input.charAt(1) != '[';
                    if (charMask && input.charAt(0) == '=') {
                        mask = this.parseFromInput(char0 + "[" + input.substring(1) + "]", context);
                    }
                    if (char0 == '#' && command.length() > 1 && command.charAt(1) != '#') {
                        throw new SuggestInputParseException(new NoMatchException((Component)Caption.of("fawe.error.parse.unknown-mask", full, TextComponent.of((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns").clickEvent(ClickEvent.openUrl((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns")))), full, () -> {
                            if (full.length() == 1) {
                                return new ArrayList<String>(this.worldEdit.getMaskFactory().getSuggestions(""));
                            }
                            return new ArrayList<String>(this.worldEdit.getMaskFactory().getSuggestions(command.toLowerCase(Locale.ROOT)));
                        });
                    }
                    if (charMask) {
                        switch (char0) {
                            case '/': 
                            case '\\': 
                            case '{': 
                            case '|': 
                            case '~': {
                                Object value = command.substring(1) + (String)(entry.getValue().isEmpty() ? "" : "[" + StringMan.join((Collection)entry.getValue(), "][") + "]");
                                if (((String)value).contains(":")) {
                                    if (((String)value).charAt(0) == ':') {
                                        value = ((String)value).replaceFirst(":", "");
                                    }
                                    value = ((String)value).replaceAll(":", "][");
                                }
                                mask = this.parseFromInput(char0 + "[" + (String)value + "]", context);
                                break;
                            }
                            case '!': 
                            case '$': 
                            case '%': 
                            case '<': 
                            case '>': {
                                input = input.substring(input.indexOf(char0) + 1);
                                mask = this.parseFromInput(char0 + "[" + input + "]", context);
                                if (mask == null) break;
                                return mask;
                            }
                            case '#': {
                                if (input.charAt(1) != '#') break;
                                mask = this.worldEdit.getMaskFactory().parseWithoutRich(full, context);
                            }
                        }
                    }
                    if (mask == null) {
                        if (command.startsWith("[")) {
                            int end = command.lastIndexOf(93);
                            mask = this.parseFromInput(command.substring(1, end == -1 ? command.length() : end), context);
                        } else {
                            BlockMaskBuilder builder = new BlockMaskBuilder();
                            try {
                                builder.addRegex(full);
                            }
                            catch (InputParseException ignored) {
                                context.setPreferringWildcard(false);
                                context.setRestricted(false);
                                BaseBlock block = (BaseBlock)this.worldEdit.getBlockFactory().parseFromInput(full, context);
                                builder.add(block);
                            }
                            catch (PatternSyntaxException e) {
                                throw new SuggestInputParseException(new NoMatchException((Component)Caption.of("fawe.error.parse.unknown-mask", full, TextComponent.of((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/masks/masks").clickEvent(ClickEvent.openUrl((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/masks/masks")))), full, () -> {
                                    if (full.length() == 1) {
                                        return new ArrayList<String>(this.worldEdit.getMaskFactory().getSuggestions(""));
                                    }
                                    return new ArrayList<String>(this.worldEdit.getMaskFactory().getSuggestions(command.toLowerCase(Locale.ROOT)));
                                });
                            }
                            mask = builder.build(extent);
                        }
                    }
                } else {
                    List<String> args = entry.getValue();
                    try {
                        mask = this.worldEdit.getMaskFactory().parseWithoutRich(full, context);
                    }
                    catch (SuggestInputParseException rethrow) {
                        throw rethrow;
                    }
                    catch (Throwable e) {
                        throw SuggestInputParseException.of(e, full, () -> {
                            try {
                                String cmdArgs = args.isEmpty() ? "" : " " + StringMan.join(args, " ");
                                List<Substring> split = CommandArgParser.forArgString(cmdArgs).parseArgs().toList();
                                List argStrings = split.stream().map(Substring::getSubstring).collect(Collectors.toList());
                                MemoizingValueAccess access = this.getPlatform().initializeInjectedValues(() -> cmdArgs, actor, null, true);
                                List suggestions = this.getPlatform().getCommandManager().getSuggestions((InjectedValueAccess)access, argStrings).stream().map(Suggestion::getSuggestion).collect(Collectors.toUnmodifiableList());
                                ArrayList<Object> result = new ArrayList<Object>();
                                if (suggestions.size() <= 2) {
                                    for (int i = 0; i < suggestions.size(); ++i) {
                                        Object suggestion = (String)suggestions.get(i);
                                        if (((String)suggestion).indexOf(32) == 0) continue;
                                        Object[] splitSuggestion = ((String)suggestion).split(" ");
                                        suggestion = "[" + StringMan.join(splitSuggestion, "][") + "]";
                                        result.set(i, suggestion);
                                    }
                                }
                                return result;
                            }
                            catch (Throwable e2) {
                                e2.printStackTrace();
                                throw new InputParseException((Component)TextComponent.of((String)e2.getMessage()));
                            }
                        });
                    }
                }
                if (pe.isAnd()) {
                    masks.add(new ArrayList());
                }
                ((List)masks.get(masks.size() - 1)).add(mask);
            }
        }
        catch (InputParseException rethrow) {
            throw rethrow;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InputParseException((Component)TextComponent.of((String)e.getMessage()), e);
        }
        ArrayList<Mask> maskUnions = new ArrayList<Mask>();
        for (List list : masks) {
            if (list.size() == 1) {
                maskUnions.add((Mask)list.get(0));
                continue;
            }
            if (list.size() == 0) continue;
            maskUnions.add(new MaskUnion(list));
        }
        if (maskUnions.size() == 1) {
            return (Mask)maskUnions.get(0);
        }
        if (maskUnions.size() != 0) {
            return new MaskIntersection(maskUnions);
        }
        return null;
    }

    @Override
    public List<String> getMatchedAliases() {
        return Collections.emptyList();
    }
}

