/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser.pattern;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.RichParser;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.awt.Color;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ColorPatternParser
extends RichParser<Pattern> {
    public ColorPatternParser(WorldEdit worldEdit) {
        super(worldEdit, "#color", "#colour");
    }

    @Override
    public Stream<String> getSuggestions(String argumentInput, int index) {
        if (index > 4) {
            return Stream.empty();
        }
        return SuggestionHelper.suggestPositiveIntegers(argumentInput);
    }

    @Override
    public Pattern parseFromInput(@Nonnull String[] input, ParserContext context) throws InputParseException {
        if (input.length != 4) {
            throw new InputParseException((Component)Caption.of("fawe.error.command.syntax", TextComponent.of((String)(this.getPrefix() + "[r][g][b][a] (e.g. " + this.getPrefix() + "[156][100][0][120])"))));
        }
        Color color = new Color(MathMan.clamp(Integer.parseInt(input[0]), 0, 255), MathMan.clamp(Integer.parseInt(input[1]), 0, 255), MathMan.clamp(Integer.parseInt(input[2]), 0, 255), MathMan.clamp(Integer.parseInt(input[3]), 0, 255));
        return context.requireSession().getTextureUtil().getNearestBlock(color.getRGB());
    }
}

