/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.platform.binding;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.platform.binding.Binding;
import com.fastasyncworldedit.core.extension.platform.binding.Bindings;
import com.fastasyncworldedit.core.extension.platform.binding.ProvideBindings;
import com.fastasyncworldedit.core.util.MainUtil;
import com.fastasyncworldedit.core.util.image.ImageUtil;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.annotation.Confirm;
import com.sk89q.worldedit.command.util.annotation.Preload;
import com.sk89q.worldedit.command.util.annotation.Time;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.PlatformCommandManager;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.UUID;
import org.enginehub.piston.exception.StopExecutionException;
import org.enginehub.piston.inject.InjectedValueAccess;

public class ConsumeBindings
extends Bindings {
    private final PlatformCommandManager manager;

    public ConsumeBindings(WorldEdit worldEdit, PlatformCommandManager manager) {
        super(worldEdit);
        this.manager = manager;
    }

    @Time
    @Binding
    public Long time(Actor actor, String argument) {
        return MainUtil.timeToSec(argument) * 1000L;
    }

    @Binding
    @Confirm(value=Confirm.Processor.REGION)
    public int regionMultiple(Actor actor, InjectedValueAccess context, @Selection Region region, String argument) {
        try {
            int times = (int)Expression.compile(argument, new String[0]).evaluate(new double[0]);
            return Confirm.Processor.REGION.check(actor, context, times);
        }
        catch (Throwable t) {
            if (t instanceof StopExecutionException) {
                throw t;
            }
            throw new InputParseException((Component)TextComponent.of((String)t.getMessage()), t);
        }
    }

    @Binding
    @Confirm(value=Confirm.Processor.RADIUS)
    public Integer radiusInteger(Actor actor, InjectedValueAccess context, String argument) {
        try {
            int times = (int)Expression.compile(argument, new String[0]).evaluate(new double[0]);
            return Confirm.Processor.RADIUS.check(actor, context, times);
        }
        catch (Throwable t) {
            if (t instanceof StopExecutionException) {
                throw t;
            }
            throw new InputParseException((Component)TextComponent.of((String)t.getMessage()), t);
        }
    }

    @Binding
    @Confirm(value=Confirm.Processor.LIMIT)
    public Integer limitInteger(Actor actor, InjectedValueAccess context, String argument) {
        try {
            int times = (int)Expression.compile(argument, new String[0]).evaluate(new double[0]);
            return Confirm.Processor.LIMIT.check(actor, context, times);
        }
        catch (Throwable t) {
            if (t instanceof StopExecutionException) {
                throw t;
            }
            throw new InputParseException((Component)TextComponent.of((String)t.getMessage()), t);
        }
    }

    @Binding
    @Confirm(value=Confirm.Processor.RADIUS)
    public Double radiusDouble(Actor actor, InjectedValueAccess context, String argument) {
        try {
            double times = Expression.compile(argument, new String[0]).evaluate(new double[0]);
            return Confirm.Processor.RADIUS.check(actor, context, times);
        }
        catch (Throwable t) {
            if (t instanceof StopExecutionException) {
                throw t;
            }
            throw new InputParseException((Component)TextComponent.of((String)t.getMessage()), t);
        }
    }

    @Binding
    @Confirm(value=Confirm.Processor.LIMIT)
    public Double limitDouble(Actor actor, InjectedValueAccess context, String argument) {
        try {
            double times = Expression.compile(argument, new String[0]).evaluate(new double[0]);
            return Confirm.Processor.LIMIT.check(actor, context, times);
        }
        catch (Throwable t) {
            if (t instanceof StopExecutionException) {
                throw t;
            }
            throw new InputParseException((Component)TextComponent.of((String)t.getMessage()), t);
        }
    }

    @Binding
    @Confirm(value=Confirm.Processor.RADIUS)
    public BlockVector2 radiusVec2(Actor actor, InjectedValueAccess context, String argument) {
        BlockVector2 radius = this.manager.parseConverter(argument, context, BlockVector2.class);
        double length = radius.length();
        Confirm.Processor.RADIUS.check(actor, context, length);
        return radius;
    }

    @Binding
    @Confirm(value=Confirm.Processor.RADIUS)
    public BlockVector3 radiusVec3(Actor actor, InjectedValueAccess context, String argument) {
        BlockVector3 radius = this.manager.parseConverter(argument, context, BlockVector3.class);
        double length = radius.length();
        Confirm.Processor.RADIUS.check(actor, context, length);
        return radius;
    }

    @Binding
    @Preload(value=Preload.PreloadCheck.PRELOAD)
    public void checkPreload(Actor actor, InjectedValueAccess context) {
        Preload.PreloadCheck.PRELOAD.preload(actor, context);
    }

    @Binding
    @Preload(value=Preload.PreloadCheck.NEVER)
    public void neverPreload(Actor actor, InjectedValueAccess context) {
    }

    @Binding
    public UUID playerUUID(Actor actor, String argument) {
        if (argument.equals("me")) {
            return actor.getUniqueId();
        }
        if (argument.equals("*")) {
            return Identifiable.EVERYONE;
        }
        if (argument.equalsIgnoreCase("console") || argument.equalsIgnoreCase("server")) {
            return Identifiable.CONSOLE;
        }
        UUID uuid = argument.length() > 16 ? UUID.fromString(argument) : Fawe.platform().getUUID(argument);
        if (uuid == null) {
            throw new InputParseException((Component)Caption.of("fawe.error.player.not.found", TextComponent.of((String)argument)));
        }
        return uuid;
    }

    @Binding
    public ProvideBindings.ImageUri getImage(String argument) {
        return new ProvideBindings.ImageUri(ImageUtil.getImageURI(argument));
    }

    @Binding
    public BlockType blockType(Actor actor, String argument) {
        return this.blockState(actor, argument).getBlockType();
    }

    @Binding
    public BlockStateHolder blockStateHolder(Actor actor, String argument) {
        return this.blockState(actor, argument);
    }

    @Binding
    public BlockState blockState(Actor actor, String argument) {
        return this.baseBlock(actor, argument).toBlockState();
    }

    @Binding
    public BaseBlock baseBlock(Actor actor, String argument) {
        Extent extent;
        ParserContext parserContext = new ParserContext();
        parserContext.setActor(actor);
        if (actor instanceof Entity && (extent = ((Entity)((Object)actor)).getExtent()) instanceof World) {
            parserContext.setWorld((World)extent);
        }
        parserContext.setSession(this.getWorldEdit().getSessionManager().get(actor));
        try {
            return (BaseBlock)this.getWorldEdit().getBlockFactory().parseFromInput(argument, parserContext);
        }
        catch (NoMatchException e) {
            throw new InputParseException((Component)TextComponent.of((String)e.getMessage()));
        }
    }
}

