/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent;

import com.fastasyncworldedit.core.extent.PassthroughExtent;
import com.sk89q.worldedit.extent.Extent;
import java.util.Arrays;

public class ExtentHeightCacher
extends PassthroughExtent {
    private transient int cacheBotX = Integer.MIN_VALUE;
    private transient int cacheBotZ = Integer.MIN_VALUE;
    private transient short[] cacheHeights;
    private transient int lastY;

    public ExtentHeightCacher(Extent extent) {
        super(extent);
    }

    public void reset() {
        this.cacheBotX = Integer.MIN_VALUE;
        this.cacheBotZ = Integer.MIN_VALUE;
        if (this.cacheHeights != null) {
            Arrays.fill(this.cacheHeights, (short)0);
        }
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        int index;
        int rx = x - this.cacheBotX + 16;
        int rz = z - this.cacheBotZ + 16;
        if ((rx & 0xFF) != rx || (rz & 0xFF) != rz) {
            this.cacheBotX = x - 16;
            this.cacheBotZ = z - 16;
            this.lastY = y;
            rx = x - this.cacheBotX + 16;
            rz = z - this.cacheBotZ + 16;
            index = rx + (rz << 8);
            if (this.cacheHeights == null) {
                this.cacheHeights = new short[65536];
                Arrays.fill(this.cacheHeights, (short)minY);
            } else {
                Arrays.fill(this.cacheHeights, (short)minY);
            }
        } else {
            index = rx + (rz << 8);
        }
        int result = this.cacheHeights[index] & 0xFF;
        if (result == minY) {
            result = this.lastY = super.getNearestSurfaceTerrainBlock(x, z, this.lastY, minY, maxY);
            this.cacheHeights[index] = (short)this.lastY;
        }
        return result;
    }
}

