/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent;

import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.math.BlockVector3ChunkMap;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.google.common.collect.ImmutableMap;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StripNBTExtent
extends AbstractDelegateExtent
implements IBatchProcessor {
    private final Set<String> strip;

    public StripNBTExtent(Extent extent, Set<String> strip) {
        super(extent);
        this.strip = new HashSet<String>(strip).stream().map(String::toLowerCase).collect(Collectors.toUnmodifiableSet());
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return super.setBlock(location, this.stripBlockNBT(block));
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        return super.setBlock(x, y, z, this.stripBlockNBT(block));
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return super.createEntity(location, this.stripEntityNBT(entity));
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        return super.createEntity(location, this.stripEntityNBT(entity), uuid);
    }

    public <B extends BlockStateHolder<B>> B stripBlockNBT(B block) {
        if (!(block instanceof BaseBlock)) {
            return block;
        }
        BaseBlock localBlock = (BaseBlock)block;
        if (!localBlock.hasNbtData()) {
            return block;
        }
        CompoundTag nbt = localBlock.getNbtData();
        HashMap<String, Tag> value = new HashMap<String, Tag>((Map<String, Tag>)nbt.getValue());
        for (String key : this.strip) {
            value.remove(key);
        }
        return (B)localBlock.toBaseBlock(new CompoundTag(value));
    }

    public <T extends NbtValued> T stripEntityNBT(T entity) {
        if (!entity.hasNbtData()) {
            return entity;
        }
        CompoundTag nbt = entity.getNbtData();
        HashMap<String, Tag> value = new HashMap<String, Tag>((Map<String, Tag>)nbt.getValue());
        for (String key : this.strip) {
            value.remove(key);
        }
        entity.setNbtData(new CompoundTag(value));
        return entity;
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        Map<BlockVector3, CompoundTag> tiles = set.getTiles();
        Set<CompoundTag> entities = set.getEntities();
        if (tiles.isEmpty() && entities.isEmpty()) {
            return set;
        }
        boolean isBv3ChunkMap = tiles instanceof BlockVector3ChunkMap;
        for (Map.Entry<BlockVector3, CompoundTag> entry : tiles.entrySet()) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            AtomicBoolean isStripped = new AtomicBoolean(false);
            entry.getValue().getValue().forEach((k, v) -> {
                if (this.strip.contains(k.toLowerCase())) {
                    isStripped.set(true);
                } else {
                    map.put(k, v);
                }
            });
            if (!isStripped.get()) continue;
            if (isBv3ChunkMap) {
                tiles.put(entry.getKey(), new CompoundTag((Map<String, Tag>)map.build()));
                continue;
            }
            entry.setValue(new CompoundTag((Map<String, Tag>)map.build()));
        }
        HashSet<CompoundTag> stripped = new HashSet<CompoundTag>();
        Iterator<CompoundTag> iterator = entities.iterator();
        while (iterator.hasNext()) {
            CompoundTag entity = iterator.next();
            ImmutableMap.Builder map = ImmutableMap.builder();
            AtomicBoolean isStripped = new AtomicBoolean(false);
            entity.getValue().forEach((k, v) -> {
                if (this.strip.contains(k.toUpperCase(Locale.ROOT))) {
                    isStripped.set(true);
                } else {
                    map.put(k, v);
                }
            });
            if (!isStripped.get()) continue;
            iterator.remove();
            stripped.add(new CompoundTag((Map<String, Tag>)map.build()));
        }
        set.getEntities().addAll(stripped);
        return set;
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        if (this.getExtent() != child) {
            new ExtentTraverser<StripNBTExtent>(this).setNext((StripNBTExtent)child);
        }
        return this;
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.CHANGING_BLOCKS;
    }
}

