/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.processor;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.EmptyBatchProcessor;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.MultiFuture;
import com.fastasyncworldedit.core.util.StringMan;
import com.google.common.cache.LoadingCache;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class MultiBatchProcessor
implements IBatchProcessor {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final LoadingCache<Class<?>, Map<Long, Filter>> classToThreadIdToFilter = FaweCache.INSTANCE.createCache(ConcurrentHashMap::new);
    private boolean[] faweExceptionReasonsUsed = new boolean[FaweException.Type.values().length];
    private IBatchProcessor[] processors;
    private int lastException = Integer.MIN_VALUE;
    private int exceptionCount = 0;

    public MultiBatchProcessor(IBatchProcessor ... processors) {
        this.processors = processors;
    }

    public static IBatchProcessor of(IBatchProcessor ... processors) {
        ArrayList<IBatchProcessor> list = new ArrayList<IBatchProcessor>();
        for (IBatchProcessor processor : processors) {
            if (processor instanceof MultiBatchProcessor) {
                list.addAll(Arrays.asList(((MultiBatchProcessor)processor).processors));
                continue;
            }
            if (processor instanceof EmptyBatchProcessor) continue;
            list.add(processor);
        }
        return switch (list.size()) {
            case 0 -> EmptyBatchProcessor.getInstance();
            case 1 -> (IBatchProcessor)list.get(0);
            default -> new MultiBatchProcessor(list.toArray(new IBatchProcessor[0]));
        };
    }

    public void addBatchProcessor(IBatchProcessor processor) {
        ArrayList<IBatchProcessor> processors = new ArrayList<IBatchProcessor>(Arrays.asList(this.processors));
        processors.add(processor);
        this.processors = processors.toArray(new IBatchProcessor[0]);
    }

    public List<IBatchProcessor> getBatchProcessors() {
        return Arrays.asList(this.processors);
    }

    public void removeBatchProcessor(IBatchProcessor processor) {
        ArrayList<IBatchProcessor> processors = new ArrayList<IBatchProcessor>(Arrays.asList(this.processors));
        processors.remove(processor);
        this.processors = processors.toArray(new IBatchProcessor[0]);
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        HashMap<Integer, Set> ordered = new HashMap<Integer, Set>();
        IChunkSet chunkSet = set;
        for (IBatchProcessor processor : this.processors) {
            if (processor.getScope() != ProcessorScope.ADDING_BLOCKS) {
                ordered.merge(processor.getScope().intValue(), new HashSet<IBatchProcessor>(Collections.singleton(processor)), (existing, theNew) -> {
                    existing.add(processor);
                    return existing;
                });
                continue;
            }
            chunkSet = this.processSet(processor, chunk, get, chunkSet);
        }
        if (ordered.size() > 0) {
            for (int i = 1; i <= 4; ++i) {
                Set processors = (Set)ordered.get(i);
                if (processors == null) continue;
                for (IBatchProcessor processor : processors) {
                    chunkSet = this.processSet(processor, chunk, get, chunkSet);
                    if (chunkSet != null) continue;
                    return null;
                }
            }
        }
        return chunkSet;
    }

    @Nullable
    private IChunkSet processSet(IBatchProcessor processor, IChunk chunk, IChunkGet get, IChunkSet chunkSet) {
        chunkSet = processor instanceof Filter ? ((IBatchProcessor)((Object)((Map)this.classToThreadIdToFilter.getUnchecked(processor.getClass())).computeIfAbsent(Thread.currentThread().getId(), k -> ((Filter)((Object)processor)).fork()))).processSet(chunk, get, chunkSet) : processor.processSet(chunk, get, chunkSet);
        return chunkSet;
    }

    @Override
    public Future<?> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        ArrayList futures = new ArrayList();
        for (IBatchProcessor processor : this.processors) {
            try {
                if (processor.getScope() != ProcessorScope.READING_SET_BLOCKS) continue;
                futures.add(processor.postProcessSet(chunk, get, set));
            }
            catch (Throwable e) {
                int hash;
                if (e instanceof FaweException) {
                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e, LOGGER);
                    continue;
                }
                if (e.getCause() instanceof FaweException) {
                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e.getCause(), LOGGER);
                    continue;
                }
                String message = e.getMessage();
                int n = hash = message != null ? message.hashCode() : 0;
                if (this.lastException != hash) {
                    this.lastException = hash;
                    this.exceptionCount = 0;
                    LOGGER.catching(e);
                    continue;
                }
                if (this.exceptionCount >= Settings.settings().QUEUE.PARALLEL_THREADS) continue;
                ++this.exceptionCount;
                LOGGER.warn(message);
            }
        }
        return new MultiFuture(futures);
    }

    @Override
    public void postProcess(IChunk chunk, IChunkGet get, IChunkSet set) {
        for (IBatchProcessor processor : this.processors) {
            try {
                if (processor.getScope() != ProcessorScope.READING_SET_BLOCKS) continue;
                processor.postProcess(chunk, get, set);
            }
            catch (Throwable e) {
                int hash;
                if (e instanceof FaweException) {
                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e, LOGGER);
                    continue;
                }
                if (e.getCause() instanceof FaweException) {
                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e.getCause(), LOGGER);
                    continue;
                }
                String message = e.getMessage();
                int n = hash = message != null ? message.hashCode() : 0;
                if (this.lastException != hash) {
                    this.lastException = hash;
                    this.exceptionCount = 0;
                    LOGGER.catching(e);
                    continue;
                }
                if (this.exceptionCount >= Settings.settings().QUEUE.PARALLEL_THREADS) continue;
                ++this.exceptionCount;
                LOGGER.warn(message);
            }
        }
    }

    @Override
    public boolean processGet(int chunkX, int chunkZ) {
        for (IBatchProcessor processor : this.processors) {
            if (processor.processGet(chunkX, chunkZ)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Extent construct(Extent child) {
        for (IBatchProcessor processor : this.processors) {
            child = processor.construct(child);
        }
        return child;
    }

    @Override
    public <T extends IBatchProcessor> IBatchProcessor remove(Class<T> clazz) {
        ArrayList<IBatchProcessor> list = new ArrayList<IBatchProcessor>(Arrays.asList(this.processors));
        list.removeIf(clazz::isInstance);
        return MultiBatchProcessor.of(list.toArray(new IBatchProcessor[0]));
    }

    @Override
    public IBatchProcessor join(IBatchProcessor other) {
        if (other instanceof MultiBatchProcessor) {
            for (IBatchProcessor processor : ((MultiBatchProcessor)other).processors) {
                this.addBatchProcessor(processor);
            }
        } else {
            this.addBatchProcessor(other);
        }
        return this;
    }

    @Override
    public IBatchProcessor joinPost(IBatchProcessor other) {
        if (other instanceof MultiBatchProcessor) {
            for (IBatchProcessor processor : ((MultiBatchProcessor)other).processors) {
                this.addBatchProcessor(processor);
            }
        } else {
            this.addBatchProcessor(other);
        }
        return this;
    }

    @Override
    public void flush() {
        for (IBatchProcessor processor : this.processors) {
            processor.flush();
        }
    }

    public String toString() {
        return super.toString() + "{" + StringMan.join(this.processors, ",") + "}";
    }

    @Override
    public ProcessorScope getScope() {
        int scope = 0;
        for (IBatchProcessor processor : this.processors) {
            scope = Math.max(scope, processor.getScope().intValue());
        }
        return ProcessorScope.valueOf(0);
    }

    public void setFaweExceptionArray(boolean[] faweExceptionReasonsUsed) {
        this.faweExceptionReasonsUsed = faweExceptionReasonsUsed;
    }
}

