/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.processor.heightmap;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Arrays;
import javax.annotation.Nullable;

public class HeightmapProcessor
implements IBatchProcessor {
    private static final HeightMapType[] TYPES = HeightMapType.values();
    private static final int BLOCKS_PER_Y_SHIFT = 8;
    private static final int BLOCKS_PER_Y = 256;
    private static final boolean[] COMPLETE = new boolean[256];
    private static final char[] AIR_LAYER = new char[4096];
    private final int minY;
    private final int maxY;

    public HeightmapProcessor(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    private static int index(int y, int offset) {
        return (y << 8) + offset;
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        int[][] heightmaps = new int[TYPES.length][256];
        boolean[][] updated = new boolean[TYPES.length][256];
        int skip = 0;
        int allSkipped = (1 << TYPES.length) - 1;
        block0: for (int layer = this.maxY >> 4; layer >= this.minY >> 4; --layer) {
            char[] setSection;
            boolean hasSectionSet = set.hasSection(layer);
            boolean hasSectionGet = get.hasSection(layer);
            if (!hasSectionSet && !hasSectionGet) continue;
            char[] cArray = setSection = hasSectionSet ? set.loadIfPresent(layer) : null;
            if (setSection == null || Arrays.equals(setSection, FaweCache.INSTANCE.EMPTY_CHAR_4096) || Arrays.equals(setSection, AIR_LAYER)) {
                hasSectionSet = false;
            }
            if (!hasSectionSet && !hasSectionGet) continue;
            char[] getSection = null;
            for (int y = 15; y >= 0; --y) {
                for (int j = 0; j < 256; ++j) {
                    BlockState block;
                    int ordinal = 0;
                    if (hasSectionSet) {
                        ordinal = setSection[HeightmapProcessor.index(y, j)];
                    }
                    if (ordinal == 0) {
                        if (!hasSectionGet) {
                            if (hasSectionSet) continue;
                            continue block0;
                        }
                        if (getSection == null && (Arrays.equals(getSection = get.load(layer), FaweCache.INSTANCE.EMPTY_CHAR_4096) || Arrays.equals(getSection, AIR_LAYER))) {
                            hasSectionGet = false;
                            if (hasSectionSet) continue;
                            continue block0;
                        }
                        ordinal = getSection[HeightmapProcessor.index(y, j)];
                    }
                    if (ordinal < 4 || (block = BlockTypesCache.states[ordinal]) == null) continue;
                    for (int i = 0; i < TYPES.length; ++i) {
                        if ((skip & 1 << i) != 0) continue;
                        HeightMapType type = TYPES[i];
                        if (updated[i][j] || !type.includes(block)) continue;
                        heightmaps[i][j] = (layer - get.getMinSectionPosition() << 4) + y + 1;
                        updated[i][j] = true;
                    }
                }
            }
            for (int i = 0; i < updated.length; ++i) {
                if ((skip & 1 << i) != 0 || !Arrays.equals(updated[i], COMPLETE)) continue;
                skip |= 1 << i;
            }
            if (skip == allSkipped) break;
        }
        for (int i = 0; i < TYPES.length; ++i) {
            set.setHeightMap(TYPES[i], heightmaps[i]);
        }
        return set;
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        throw new UnsupportedOperationException("Processing only");
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.READING_SET_BLOCKS;
    }

    static {
        Arrays.fill(COMPLETE, true);
        Arrays.fill(AIR_LAYER, '\u0001');
    }
}

