/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.mask;

import com.fastasyncworldedit.core.function.mask.MaskUnion2D;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MaskUnion
extends MaskIntersection {
    public MaskUnion(Collection<Mask> masks) {
        super(masks);
    }

    public MaskUnion(Mask ... mask) {
        super(mask);
    }

    public static Mask of(Mask ... masks) {
        LinkedHashSet<Mask> set = new LinkedHashSet<Mask>();
        for (Mask mask : masks) {
            if (mask == Masks.alwaysTrue()) {
                return mask;
            }
            if (mask == null) continue;
            if (mask.getClass() == MaskUnion.class) {
                set.addAll(((MaskUnion)mask).getMasks());
                continue;
            }
            set.add(mask);
        }
        return switch (set.size()) {
            case 0 -> Masks.alwaysTrue();
            case 1 -> (Mask)set.iterator().next();
            default -> new MaskUnion(masks).optimize();
        };
    }

    @Override
    public Function<Map.Entry<Mask, Mask>, Mask> pairingFunction() {
        return input -> ((Mask)input.getKey()).tryOr((Mask)input.getValue());
    }

    @Override
    public boolean test(BlockVector3 vector) {
        Mask[] masks;
        for (Mask mask : masks = this.getMasksArray()) {
            if (!mask.test(vector)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        ArrayList<Mask2D> mask2dList = new ArrayList<Mask2D>();
        for (Mask mask : this.getMasks()) {
            Mask2D mask2d = mask.toMask2D();
            if (mask2d != null) {
                mask2dList.add(mask2d);
                continue;
            }
            return null;
        }
        return new MaskUnion2D(mask2dList);
    }

    @Override
    public Mask copy() {
        Set<Mask> masksCopy = this.masks.stream().map(Mask::copy).collect(Collectors.toSet());
        return new MaskUnion(masksCopy);
    }

    @Override
    public boolean replacesAir() {
        for (Mask mask : this.getMasksArray()) {
            if (!mask.replacesAir()) continue;
            return true;
        }
        return false;
    }
}

