/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.pattern;

import com.fastasyncworldedit.core.function.pattern.ResettablePattern;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;

public class LinearBlockPattern
extends AbstractPattern
implements ResettablePattern {
    private final Pattern[] patternsArray;
    private transient int index;

    public LinearBlockPattern(Pattern[] patterns) {
        this.patternsArray = patterns;
    }

    @Override
    public BaseBlock applyBlock(BlockVector3 position) {
        if (this.index == this.patternsArray.length) {
            this.index = 0;
        }
        return this.patternsArray[this.index++].applyBlock(position);
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        if (this.index == this.patternsArray.length) {
            this.index = 0;
        }
        return this.patternsArray[this.index++].apply(extent, get, set);
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

