/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.pattern;

import com.fastasyncworldedit.core.function.pattern.ResettablePattern;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;

public class RelativePattern
extends AbstractPattern
implements ResettablePattern {
    private final Pattern pattern;
    private final int minY;
    private final int maxY;
    private final MutableBlockVector3 mutable = new MutableBlockVector3();
    private BlockVector3 origin;

    public RelativePattern(Pattern pattern, int minY, int maxY) {
        this.pattern = pattern;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public BaseBlock applyBlock(BlockVector3 pos) {
        if (this.origin == null) {
            this.origin = pos;
        }
        this.mutable.mutX(pos.getX() - this.origin.getX());
        this.mutable.mutY(pos.getY() - this.origin.getY());
        this.mutable.mutZ(pos.getZ() - this.origin.getZ());
        if (this.mutable.getY() < this.minY || this.mutable.getY() > this.maxY) {
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        return this.pattern.applyBlock(this.mutable);
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        if (this.origin == null) {
            this.origin = set;
        }
        this.mutable.mutX(set.getX() - this.origin.getX());
        this.mutable.mutY(set.getY() - this.origin.getY());
        this.mutable.mutZ(set.getZ() - this.origin.getZ());
        if (this.mutable.getY() < extent.getMinY() || this.mutable.getY() > extent.getMaxY()) {
            return false;
        }
        return this.pattern.apply(extent, get, this.mutable);
    }

    @Override
    public void reset() {
        this.origin = null;
    }
}

