/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.history.change;

import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.Logger;

public class MutableEntityChange
implements Change {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    public CompoundTag tag;
    public boolean create;

    public MutableEntityChange(CompoundTag tag, boolean create) {
        this.tag = tag;
        this.create = create;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        if (!this.create) {
            this.create(context);
        } else {
            this.delete(context);
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        if (this.create) {
            this.create(context);
        } else {
            this.delete(context);
        }
    }

    public void delete(UndoContext context) {
        Object map = this.tag.getValue();
        UUID uuid = this.tag.getUUID();
        if (uuid == null) {
            LOGGER.info("Skipping entity without uuid.");
            return;
        }
        List pos = (List)((Tag)map.get("Pos")).getValue();
        int x = MathMan.roundInt(((DoubleTag)pos.get(0)).getValue());
        int y = MathMan.roundInt(((DoubleTag)pos.get(1)).getValue());
        int z = MathMan.roundInt(((DoubleTag)pos.get(2)).getValue());
        context.getExtent().removeEntity(x, y, z, uuid);
    }

    public void create(UndoContext context) {
        Object map = this.tag.getValue();
        Tag posTag = (Tag)map.get("Pos");
        if (posTag == null) {
            LOGGER.warn("Missing pos tag: {}", (Object)this.tag);
            return;
        }
        List pos = (List)posTag.getValue();
        double x = ((DoubleTag)pos.get(0)).getValue();
        double y = ((DoubleTag)pos.get(1)).getValue();
        double z = ((DoubleTag)pos.get(2)).getValue();
        Extent extent = context.getExtent();
        Location location = new Location(extent, x, y, z, 0.0f, 0.0f);
        String id = this.tag.getString("id");
        EntityType type = EntityTypes.parse(id);
        BaseEntity entity = new BaseEntity(type, this.tag);
        extent.createEntity(location, entity, this.tag.getUUID());
    }
}

