/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.internal.exception;

import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.Locale;

public class FaweException
extends RuntimeException {
    public static final FaweException _enableQueue = new FaweException("enableQueue");
    public static final FaweException _disableQueue = new FaweException("disableQueue");
    private final Component message;
    private final Type type;

    public FaweException(String reason) {
        this((Component)TextComponent.of((String)reason));
    }

    public FaweException(Component reason) {
        this(reason, Type.OTHER);
    }

    public FaweException(Component reason, Type type) {
        this.message = reason;
        this.type = type;
    }

    @Override
    public String getMessage() {
        return WorldEditText.reduceToText(this.message, Locale.ROOT);
    }

    public Component getComponent() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public static FaweException get(Throwable e) {
        if (e instanceof FaweException) {
            return (FaweException)e;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return null;
        }
        return FaweException.get(cause);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public static enum Type {
        MANUAL,
        NO_REGION,
        OUTSIDE_REGION,
        MAX_CHECKS,
        MAX_CHANGES,
        LOW_MEMORY,
        MAX_ENTITIES,
        MAX_TILES,
        MAX_ITERATIONS,
        BLOCK_BAG,
        CHUNK,
        PLAYER_ONLY,
        ACTOR_REQUIRED,
        CLIPBOARD,
        HISTORY,
        OTHER;

    }
}

