/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.internal.io;

import com.fastasyncworldedit.core.util.IOUtil;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FaweInputStream
extends DataInputStream {
    private final InputStream parent;
    private NBTInputStream nbtIn;

    public FaweInputStream(InputStream parent) {
        super(parent);
        this.parent = parent;
    }

    public InputStream getParent() {
        return this.parent;
    }

    public int readMedium() throws IOException {
        return (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public void skipFully(int num) throws IOException {
        for (long skipped = this.skip(num); skipped != (long)num; skipped += this.skip((long)num - skipped)) {
        }
    }

    public NamedTag readNBT() throws IOException {
        if (this.nbtIn == null) {
            this.nbtIn = new NBTInputStream(this.parent);
        }
        return this.nbtIn.readNamedTag();
    }

    public Object readPrimitive(Class<?> clazz) throws IOException {
        if (clazz == Long.TYPE || clazz == Long.class) {
            return this.readLong();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return this.readDouble();
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(this.readFloat());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return this.readInt();
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return this.readShort();
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(this.readChar());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return this.readByte();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return this.readBoolean();
        }
        throw new UnsupportedOperationException("Unknown class " + clazz);
    }

    public final int readVarInt() throws IOException {
        return IOUtil.readVarInt(this);
    }

    @Override
    public void close() throws IOException {
        if (this.nbtIn != null) {
            this.nbtIn.close();
        }
        this.parent.close();
    }
}

