/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.internal.io.FastByteArrayOutputStream;
import com.fastasyncworldedit.core.internal.io.FaweOutputStream;
import com.fastasyncworldedit.core.queue.Trimable;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.registry.BlockRegistry;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public interface IBlocks
extends Trimable {
    public boolean hasSection(int var1);

    public char[] load(int var1);

    @Nullable
    public char[] loadIfPresent(int var1);

    public BlockState getBlock(int var1, int var2, int var3);

    public Map<BlockVector3, CompoundTag> getTiles();

    public CompoundTag getTile(int var1, int var2, int var3);

    public Set<CompoundTag> getEntities();

    public BiomeType getBiomeType(int var1, int var2, int var3);

    default public int getBitMask() {
        return IntStream.range(this.getMinSectionPosition(), this.getMaxSectionPosition() + 1).filter(this::hasSection).map(layer -> 1 << layer).sum();
    }

    public void removeSectionLighting(int var1, boolean var2);

    public boolean trim(boolean var1, int var2);

    public IBlocks reset();

    public int getSectionCount();

    public int getMaxSectionPosition();

    public int getMinSectionPosition();

    default public byte[] toByteArray(boolean full, boolean stretched) {
        return this.toByteArray(null, this.getBitMask(), full, stretched);
    }

    default public byte[] toByteArray(byte[] buffer, int bitMask, boolean full, boolean stretched) {
        if (buffer == null) {
            buffer = new byte[1024];
        }
        BlockRegistry registry = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry();
        FastByteArrayOutputStream sectionByteArray = new FastByteArrayOutputStream(buffer);
        try (FaweOutputStream sectionWriter = new FaweOutputStream(sectionByteArray);){
            for (int layer = 0; layer < this.getSectionCount(); ++layer) {
                int i;
                if (!this.hasSection(layer) || (bitMask & 1 << layer) == 0) continue;
                char[] ids = this.load(layer);
                int nonEmpty = 0;
                block15: for (int i2 = 0; i2 < ids.length; ++i2) {
                    char ordinal = ids[i2];
                    switch (ordinal) {
                        case '\u0000': 
                        case '\u0002': 
                        case '\u0003': {
                            ids[i2] = '\u0001';
                        }
                        case '\u0001': {
                            continue block15;
                        }
                        default: {
                            ++nonEmpty;
                        }
                    }
                }
                sectionWriter.writeShort(nonEmpty);
                FaweCache.Palette palette = stretched ? FaweCache.INSTANCE.toPalette(0, ids) : FaweCache.INSTANCE.toPaletteUnstretched(0, ids);
                sectionWriter.writeByte(palette.bitsPerEntry);
                sectionWriter.writeVarInt(palette.paletteToBlockLength);
                block16: for (i = 0; i < palette.paletteToBlockLength; ++i) {
                    int ordinal = palette.paletteToBlock[i];
                    switch (ordinal) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            sectionWriter.write(0);
                            continue block16;
                        }
                        default: {
                            BlockState state = BlockState.getFromOrdinal(ordinal);
                            int mcId = registry.getInternalBlockStateId(state).getAsInt();
                            sectionWriter.writeVarInt(mcId);
                        }
                    }
                }
                sectionWriter.writeVarInt(palette.blockStatesLength);
                for (i = 0; i < palette.blockStatesLength; ++i) {
                    sectionWriter.writeLong(palette.blockStates[i]);
                }
            }
            if (full) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        BiomeType biome = this.getBiomeType(x, 0, z);
                        if (biome != null) {
                            sectionWriter.writeInt(biome.getLegacyId());
                            continue;
                        }
                        sectionWriter.writeInt(0);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sectionByteArray.toByteArray();
    }
}

