/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.PassthroughExtent;
import com.fastasyncworldedit.core.extent.filter.block.CharFilterBlock;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.extent.processor.EmptyBatchProcessor;
import com.fastasyncworldedit.core.extent.processor.ExtentBatchProcessorHolder;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.blocks.CharSetBlocks;
import com.fastasyncworldedit.core.queue.implementation.chunk.ChunkHolder;
import com.fastasyncworldedit.core.queue.implementation.chunk.NullChunk;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.MemUtil;
import com.fastasyncworldedit.core.wrappers.WorldWrapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public class SingleThreadQueueExtent
extends ExtentBatchProcessorHolder
implements IQueueExtent<IQueueChunk> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Long2ObjectLinkedOpenHashMap<IQueueChunk> chunks = new Long2ObjectLinkedOpenHashMap();
    private final ConcurrentLinkedQueue<Future> submissions = new ConcurrentLinkedQueue();
    private final ReentrantLock getChunkLock = new ReentrantLock();
    private World world = null;
    private int minY = 0;
    private int maxY = 255;
    private IChunkCache<IChunkGet> cacheGet;
    private IChunkCache<IChunkSet> cacheSet;
    private boolean initialized;
    private Thread currentThread;
    private IQueueChunk lastChunk;
    private long lastPair = Long.MAX_VALUE;
    private boolean enabledQueue = true;
    private boolean fastmode = false;
    private boolean[] faweExceptionReasonsUsed = new boolean[FaweException.Type.values().length];
    private int lastException = Integer.MIN_VALUE;
    private int exceptionCount = 0;

    public SingleThreadQueueExtent() {
    }

    public SingleThreadQueueExtent(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    private void checkThread() {
        if (Thread.currentThread() != this.currentThread && this.currentThread != null) {
            throw new UnsupportedOperationException("This class must be used from a single thread. Use multiple queues for concurrent operations");
        }
    }

    @Override
    public void enableQueue() {
        this.enabledQueue = true;
    }

    @Override
    public void disableQueue() {
        this.enabledQueue = false;
    }

    @Override
    public IChunkGet getCachedGet(int chunkX, int chunkZ) {
        return this.cacheGet.get(chunkX, chunkZ);
    }

    @Override
    public IChunkSet getCachedSet(int chunkX, int chunkZ) {
        return this.cacheSet.get(chunkX, chunkZ);
    }

    @Override
    public boolean isFastMode() {
        return this.fastmode;
    }

    @Override
    public void setFastMode(boolean fastmode) {
        this.fastmode = fastmode;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    public void setFaweExceptionArray(boolean[] faweExceptionReasonsUsed) {
        this.faweExceptionReasonsUsed = faweExceptionReasonsUsed;
    }

    protected synchronized void reset() {
        if (!this.initialized) {
            return;
        }
        if (!this.chunks.isEmpty()) {
            for (IChunk chunk : this.chunks.values()) {
                chunk.recycle();
            }
            this.getChunkLock.lock();
            this.chunks.clear();
            this.getChunkLock.unlock();
        }
        this.enabledQueue = true;
        this.lastChunk = null;
        this.lastPair = Long.MAX_VALUE;
        this.currentThread = null;
        this.initialized = false;
        this.setProcessor(EmptyBatchProcessor.getInstance());
        this.setPostProcessor(EmptyBatchProcessor.getInstance());
        this.world = null;
    }

    @Override
    public synchronized void init(Extent extent, IChunkCache<IChunkGet> get, IChunkCache<IChunkSet> set) {
        this.reset();
        this.minY = extent.getMinY();
        this.maxY = extent.getMaxY();
        this.currentThread = Thread.currentThread();
        if (get == null) {
            get = (x, z) -> {
                throw new UnsupportedOperationException();
            };
        }
        if (set == null) {
            set = (x, z) -> CharSetBlocks.newInstance();
        }
        this.cacheGet = get;
        this.cacheSet = set;
        this.setProcessor(EmptyBatchProcessor.getInstance());
        this.setPostProcessor(EmptyBatchProcessor.getInstance());
        this.initialized = true;
        this.world = extent.isWorld() ? (World)(extent instanceof PassthroughExtent ? ((PassthroughExtent)extent).getExtent() : extent) : (extent instanceof EditSession ? ((EditSession)extent).getWorld() : WorldWrapper.unwrap(extent));
    }

    @Override
    public int size() {
        return this.chunks.size() + this.submissions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty() && this.submissions.isEmpty();
    }

    @Override
    public <V extends Future<V>> V submit(IQueueChunk chunk) {
        if (this.lastChunk == chunk) {
            this.lastPair = Long.MAX_VALUE;
            this.lastChunk = null;
        }
        long index = MathMan.pairInt(chunk.getX(), chunk.getZ());
        this.getChunkLock.lock();
        this.chunks.remove(index, (Object)chunk);
        this.getChunkLock.unlock();
        V future = this.submitUnchecked(chunk);
        this.submissions.add((Future)future);
        return future;
    }

    private <V extends Future<V>> V submitUnchecked(IQueueChunk chunk) {
        if (chunk.isEmpty()) {
            chunk.recycle();
            ListenableFuture result = Futures.immediateFuture(null);
            return (V)result;
        }
        if (Fawe.isMainThread()) {
            Object result = chunk.call();
            if (result == null) {
                return (V)Futures.immediateFuture(null);
            }
            return (V)result;
        }
        return (V)Fawe.instance().getQueueHandler().submit(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean trim(boolean aggressive) {
        this.cacheGet.trim(aggressive);
        this.cacheSet.trim(aggressive);
        if (Thread.currentThread() == this.currentThread) {
            this.lastChunk = null;
            this.lastPair = Long.MAX_VALUE;
            return this.chunks.isEmpty();
        }
        if (!this.submissions.isEmpty()) {
            if (aggressive) {
                this.pollSubmissions(0, aggressive);
            } else {
                this.pollSubmissions(Settings.settings().QUEUE.PARALLEL_THREADS, aggressive);
            }
        }
        SingleThreadQueueExtent singleThreadQueueExtent = this;
        synchronized (singleThreadQueueExtent) {
            return this.currentThread == null;
        }
    }

    private ChunkHolder poolOrCreate(int chunkX, int chunkZ) {
        ChunkHolder next = this.create(false);
        next.init(this, chunkX, chunkZ);
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IQueueChunk getOrCreateChunk(int x, int z) {
        this.getChunkLock.lock();
        try {
            Object future;
            long pair = (long)x << 32 | (long)z & 0xFFFFFFFFL;
            if (pair == this.lastPair) {
                IQueueChunk iQueueChunk = this.lastChunk;
                return iQueueChunk;
            }
            if (!this.processGet(x, z)) {
                this.lastPair = pair;
                this.lastChunk = NullChunk.getInstance();
                NullChunk nullChunk = NullChunk.getInstance();
                return nullChunk;
            }
            IQueueChunk chunk = (IQueueChunk)this.chunks.get(pair);
            if (chunk != null) {
                this.lastPair = pair;
                this.lastChunk = chunk;
                IQueueChunk iQueueChunk = chunk;
                return iQueueChunk;
            }
            int size = this.chunks.size();
            boolean lowMem = MemUtil.isMemoryLimited();
            if (this.enabledQueue && (lowMem && size > Settings.settings().QUEUE.PARALLEL_THREADS + 8 || size > Settings.settings().QUEUE.TARGET_SIZE && Fawe.instance().getQueueHandler().isUnderutilized()) && (future = this.submitUnchecked(chunk = (IQueueChunk)this.chunks.removeFirst())) != null && !future.isDone()) {
                int targetSize = lowMem ? Settings.settings().QUEUE.PARALLEL_THREADS + 8 : Settings.settings().QUEUE.TARGET_SIZE;
                this.pollSubmissions(targetSize, lowMem);
                this.submissions.add((Future)future);
            }
            chunk = this.poolOrCreate(x, z);
            chunk = this.wrap(chunk);
            this.chunks.put(pair, (Object)chunk);
            this.lastPair = pair;
            this.lastChunk = chunk;
            IQueueChunk iQueueChunk = chunk;
            return iQueueChunk;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    public void addChunkLoad(int cx, int cz) {
        if (this.world == null) {
            return;
        }
        this.world.checkLoadedChunk(BlockVector3.at(cx << 4, 0, cz << 4));
    }

    public void preload(Region region) {
        if (Settings.settings().QUEUE.PRELOAD_CHUNK_COUNT > 1) {
            int loadCount = 0;
            for (BlockVector2 from : region.getChunks()) {
                if (loadCount >= Settings.settings().QUEUE.PRELOAD_CHUNK_COUNT) break;
                ++loadCount;
                this.addChunkLoad(from.getBlockX(), from.getBlockZ());
            }
        }
    }

    @Override
    public ChunkHolder create(boolean isFull) {
        return ChunkHolder.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollSubmissions(int targetSize, boolean aggressive) {
        int overflow = this.submissions.size() - targetSize;
        if (aggressive) {
            if (targetSize == 0) {
                while (!this.submissions.isEmpty()) {
                    this.iterateSubmissions();
                }
            }
            for (int i = 0; i < overflow; ++i) {
                this.iterateSubmissions();
            }
        } else {
            for (int i = 0; i < overflow; ++i) {
                Future next = this.submissions.peek();
                while (next != null) {
                    if (next.isDone()) {
                        Future after = null;
                        try {
                            after = (Future)next.get();
                            continue;
                        }
                        catch (FaweException e) {
                            Fawe.handleFaweException(this.faweExceptionReasonsUsed, e, LOGGER);
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            int hash;
                            if (e.getCause() instanceof FaweException) {
                                Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e.getCause(), LOGGER);
                                continue;
                            }
                            String message = e.getMessage();
                            int n = hash = message != null ? message.hashCode() : 0;
                            if (this.lastException != hash) {
                                this.lastException = hash;
                                this.exceptionCount = 0;
                                LOGGER.catching((Throwable)e);
                                continue;
                            }
                            if (this.exceptionCount >= Settings.settings().QUEUE.PARALLEL_THREADS) continue;
                            ++this.exceptionCount;
                            LOGGER.warn(message);
                            continue;
                        }
                        finally {
                            next = after;
                            continue;
                        }
                    }
                    return;
                }
                this.submissions.poll();
            }
        }
    }

    private void iterateSubmissions() {
        block6: {
            try {
                for (Future first = this.submissions.poll(); first != null; first = (Future)first.get()) {
                }
            }
            catch (FaweException e) {
                Fawe.handleFaweException(this.faweExceptionReasonsUsed, e, LOGGER);
            }
            catch (InterruptedException | ExecutionException e) {
                int hash;
                if (e.getCause() instanceof FaweException) {
                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)e.getCause(), LOGGER);
                }
                String message = e.getMessage();
                int n = hash = message != null ? message.hashCode() : 0;
                if (this.lastException != hash) {
                    this.lastException = hash;
                    this.exceptionCount = 0;
                    LOGGER.catching((Throwable)e);
                }
                if (this.exceptionCount >= Settings.settings().QUEUE.PARALLEL_THREADS) break block6;
                ++this.exceptionCount;
                LOGGER.warn(message);
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.chunks.isEmpty()) {
            if (MemUtil.isMemoryLimited()) {
                for (IQueueChunk chunk : this.chunks.values()) {
                    Object future = this.submitUnchecked(chunk);
                    if (future == null || future.isDone()) continue;
                    this.pollSubmissions(Settings.settings().QUEUE.PARALLEL_THREADS, true);
                    this.submissions.add((Future)future);
                }
            } else {
                for (IQueueChunk chunk : this.chunks.values()) {
                    Object future = this.submitUnchecked(chunk);
                    if (future == null || future.isDone()) continue;
                    this.submissions.add((Future)future);
                }
            }
            this.getChunkLock.lock();
            this.chunks.clear();
            this.getChunkLock.unlock();
        }
        this.pollSubmissions(0, true);
    }

    @Override
    public ChunkFilterBlock initFilterBlock() {
        return new CharFilterBlock(this);
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.ADDING_BLOCKS;
    }
}

