/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.blocks;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.collection.MemBlockSet;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class BitSetBlocks
implements IChunkSet {
    private final MemBlockSet.RowZ row;
    private final BlockState blockState;
    private final int minSectionPosition;
    private final int maxSectionPosition;
    private final int layers;

    public BitSetBlocks(BlockState blockState, int minSectionPosition, int maxSectionPosition) {
        this.row = new MemBlockSet.RowZ(minSectionPosition, maxSectionPosition);
        this.blockState = blockState;
        this.minSectionPosition = minSectionPosition;
        this.maxSectionPosition = maxSectionPosition;
        this.layers = maxSectionPosition - minSectionPosition + 1;
    }

    @Override
    public boolean hasSection(int layer) {
        return this.row.rows[layer -= this.minSectionPosition] != MemBlockSet.NULL_ROW_Y;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return false;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T holder) {
        this.row.set(null, x, y -= this.minSectionPosition << 4, z, this.minSectionPosition, this.maxSectionPosition);
        return true;
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.row.reset(layer -= this.minSectionPosition);
        int by = layer << 4;
        int index = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                int x = 0;
                while (x < 16) {
                    if (data[index] != '\u0000') {
                        this.row.set(null, x, by + y, z, this.minSectionPosition, this.maxSectionPosition);
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.row.isEmpty();
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) {
        return false;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
    }

    @Override
    public void setFullBright(int layer) {
    }

    @Override
    public void setEntity(CompoundTag tag) {
    }

    @Override
    public void removeEntity(UUID uuid) {
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        if (this.row.get(null, x, y, z)) {
            return this.blockState;
        }
        return null;
    }

    @Override
    public char[] load(int layer) {
        char[] arr = (char[])FaweCache.INSTANCE.SECTION_BITS_TO_CHAR.get();
        MemBlockSet.IRow nullRowY = this.row.getRow(layer -= this.minSectionPosition);
        if (nullRowY instanceof MemBlockSet.RowY) {
            MemBlockSet.RowY rowY = (MemBlockSet.RowY)nullRowY;
            char value = this.blockState.getOrdinalChar();
            long[] bits = rowY.getBits();
            int longIndex = 0;
            int blockIndex = 0;
            for (int y = 0; y < 16; ++y) {
                int z = 0;
                while (z < 16) {
                    long bitBuffer = bits[longIndex];
                    if (bitBuffer != 0L) {
                        if (bitBuffer == -1L) {
                            Arrays.fill(arr, blockIndex, blockIndex + 64, value);
                        } else {
                            long lowBit;
                            Arrays.fill(arr, '\u0000');
                            do {
                                lowBit = Long.lowestOneBit(bitBuffer);
                                int bitIndex = Long.bitCount(lowBit - 1L);
                                arr[blockIndex + bitIndex] = value;
                            } while ((bitBuffer ^= lowBit) != 0L);
                        }
                    }
                    z += 4;
                    ++longIndex;
                    blockIndex += 64;
                }
            }
        }
        return arr;
    }

    @Override
    @Nullable
    public char[] loadIfPresent(int layer) {
        return this.load(layer);
    }

    @Override
    public BiomeType[][] getBiomes() {
        return null;
    }

    @Override
    public char[][] getLight() {
        return new char[0][];
    }

    @Override
    public char[][] getSkyLight() {
        return new char[0][];
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return null;
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return Collections.emptyMap();
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return null;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return Collections.emptySet();
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return null;
    }

    @Override
    public IChunkSet reset() {
        this.row.reset();
        return this;
    }

    @Override
    public boolean hasBiomes(int layer) {
        return false;
    }

    @Override
    public int getSectionCount() {
        return this.layers;
    }

    @Override
    public int getMaxSectionPosition() {
        return this.minSectionPosition;
    }

    @Override
    public int getMinSectionPosition() {
        return this.maxSectionPosition;
    }

    @Override
    public boolean trim(boolean aggressive) {
        return false;
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return false;
    }
}

