/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.blocks;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.math.BlockVector3ChunkMap;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.Pool;
import com.fastasyncworldedit.core.queue.implementation.blocks.CharBlocks;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;

public class CharSetBlocks
extends CharBlocks
implements IChunkSet {
    private static final Pool<CharSetBlocks> POOL = FaweCache.INSTANCE.registerPool(CharSetBlocks.class, CharSetBlocks::new, Settings.settings().QUEUE.POOL);
    public BiomeType[][] biomes;
    public char[][] light;
    public char[][] skyLight;
    public BlockVector3ChunkMap<CompoundTag> tiles;
    public HashSet<CompoundTag> entities;
    public HashSet<UUID> entityRemoves;
    public Map<HeightMapType, int[]> heightMaps;
    private boolean fastMode = false;
    private int bitMask = -1;

    public static CharSetBlocks newInstance() {
        return POOL.poll();
    }

    private CharSetBlocks() {
        super(0, 15);
    }

    @Override
    public synchronized void recycle() {
        this.reset();
        POOL.offer(this);
    }

    @Override
    public BiomeType[][] getBiomes() {
        return this.biomes;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        if (this.biomes == null || y >> 4 < this.minSectionPosition || y >> 4 > this.maxSectionPosition) {
            return null;
        }
        int layer = (y >> 4) - this.minSectionPosition;
        if (this.biomes[layer] == null) {
            return null;
        }
        return this.biomes[layer][(y & 0xF) >> 2 | z >> 2 << 2 | x >> 2];
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return this.tiles == null ? Collections.emptyMap() : this.tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return this.tiles == null ? null : this.tiles.get(x, y, z);
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return this.entities == null ? Collections.emptySet() : this.entities;
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return this.entityRemoves == null ? Collections.emptySet() : this.entityRemoves;
    }

    @Override
    public Map<HeightMapType, int[]> getHeightMaps() {
        return this.heightMaps == null ? new HashMap() : this.heightMaps;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.updateSectionIndexRange(y >> 4);
        int layer = (y >> 4) - this.minSectionPosition;
        if (this.biomes == null) {
            this.biomes = new BiomeType[this.sectionCount][];
            this.biomes[layer] = new BiomeType[64];
        } else if (this.biomes[layer] == null) {
            this.biomes[layer] = new BiomeType[64];
        }
        this.biomes[layer][(y & 0xC) << 2 | z & 0xC | (x & 0xC) >> 2] = biome;
        return true;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T holder) {
        this.updateSectionIndexRange(y >> 4);
        this.set(x, y, z, holder.getOrdinalChar());
        holder.applyTileEntity(this, x, y, z);
        return true;
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.updateSectionIndexRange(layer);
        this.sections[layer -= this.minSectionPosition] = data == null ? EMPTY : FULL;
        this.blocks[layer] = data;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        return this.setBlock(position.getX(), position.getY(), position.getZ(), block);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) {
        if (this.tiles == null) {
            this.tiles = new BlockVector3ChunkMap();
        }
        this.updateSectionIndexRange(y >> 4);
        this.tiles.put(x, y, z, tile);
        return true;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        int layer;
        this.updateSectionIndexRange(y >> 4);
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer = (y >> 4) - this.minSectionPosition] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.light[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.light[layer][index] = (char)value;
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        int layer;
        this.updateSectionIndexRange(y >> 4);
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        if (this.skyLight[layer = (y >> 4) - this.minSectionPosition] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.skyLight[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.skyLight[layer][index] = (char)value;
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
        if (this.heightMaps == null) {
            this.heightMaps = new HashMap<HeightMapType, int[]>();
        }
        this.heightMaps.put(type, heightMap);
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
        this.updateSectionIndexRange(layer);
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        this.light[layer -= this.minSectionPosition] = toSet;
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
        this.updateSectionIndexRange(layer);
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        this.skyLight[layer -= this.minSectionPosition] = toSet;
    }

    @Override
    public char[][] getLight() {
        return this.light;
    }

    @Override
    public char[][] getSkyLight() {
        return this.skyLight;
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        this.updateSectionIndexRange(layer);
        layer -= this.minSectionPosition;
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u0000');
        if (sky) {
            if (this.skyLight == null) {
                this.skyLight = new char[this.sectionCount][];
            }
            if (this.skyLight[layer] == null) {
                this.skyLight[layer] = new char[4096];
            }
            Arrays.fill(this.skyLight[layer], '\u0000');
        }
    }

    @Override
    public void setFullBright(int layer) {
        this.updateSectionIndexRange(layer);
        layer -= this.minSectionPosition;
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        if (this.skyLight[layer] == null) {
            this.skyLight[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u000f');
        Arrays.fill(this.skyLight[layer], '\u000f');
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.getX(), position.getY(), position.getZ(), biome);
    }

    @Override
    public void setEntity(CompoundTag tag) {
        if (this.entities == null) {
            this.entities = new HashSet();
        }
        this.entities.add(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        if (this.entityRemoves == null) {
            this.entityRemoves = new HashSet();
        }
        this.entityRemoves.add(uuid);
    }

    @Override
    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    @Override
    public boolean isFastMode() {
        return this.fastMode;
    }

    @Override
    public void setBitMask(int bitMask) {
        this.bitMask = bitMask;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public boolean isEmpty() {
        if (this.biomes != null || this.light != null || this.skyLight != null || this.entities != null && !this.entities.isEmpty() || this.tiles != null && !this.tiles.isEmpty() || this.entityRemoves != null && !this.entityRemoves.isEmpty() || this.heightMaps != null && !this.heightMaps.isEmpty()) {
            return false;
        }
        return !IntStream.range(this.minSectionPosition, this.maxSectionPosition + 1).anyMatch(this::hasSection);
    }

    @Override
    public IChunkSet reset() {
        this.biomes = null;
        this.tiles = null;
        this.entities = null;
        this.entityRemoves = null;
        super.reset();
        return null;
    }

    @Override
    public boolean hasBiomes(int layer) {
        if ((layer -= this.minSectionPosition) < 0 || layer >= this.sections.length) {
            return false;
        }
        return this.biomes != null && this.biomes[layer] != null;
    }

    @Override
    public char[] load(int layer) {
        this.updateSectionIndexRange(layer);
        return super.load(layer);
    }

    @Override
    protected char defaultOrdinal() {
        return '\u0000';
    }

    private void updateSectionIndexRange(int layer) {
        if (layer >= this.minSectionPosition && layer <= this.maxSectionPosition) {
            return;
        }
        if (layer < this.minSectionPosition) {
            int diff = this.minSectionPosition - layer;
            this.sectionCount += diff;
            char[][] tmpBlocks = new char[this.sectionCount][];
            CharBlocks.Section[] tmpSections = new CharBlocks.Section[this.sectionCount];
            Object[] tmpSectionLocks = new Object[this.sectionCount];
            System.arraycopy(this.blocks, 0, tmpBlocks, diff, this.blocks.length);
            System.arraycopy(this.sections, 0, tmpSections, diff, this.sections.length);
            System.arraycopy(this.sectionLocks, 0, tmpSectionLocks, diff, this.sections.length);
            for (int i = 0; i < diff; ++i) {
                tmpSections[i] = EMPTY;
                tmpSectionLocks[i] = new Object();
            }
            this.blocks = tmpBlocks;
            this.sections = tmpSections;
            this.sectionLocks = tmpSectionLocks;
            this.minSectionPosition = layer;
            if (this.biomes != null) {
                BiomeType[][] tmpBiomes = new BiomeType[this.sectionCount][64];
                System.arraycopy(this.biomes, 0, tmpBiomes, diff, this.biomes.length);
                this.biomes = tmpBiomes;
            }
            if (this.light != null) {
                char[][] tmplight = new char[this.sectionCount][];
                System.arraycopy(this.light, 0, tmplight, diff, this.light.length);
                this.light = tmplight;
            }
            if (this.skyLight != null) {
                char[][] tmplight = new char[this.sectionCount][];
                System.arraycopy(this.skyLight, 0, tmplight, diff, this.skyLight.length);
                this.skyLight = tmplight;
            }
        } else {
            int diff = layer - this.maxSectionPosition;
            this.sectionCount += diff;
            char[][] tmpBlocks = new char[this.sectionCount][];
            CharBlocks.Section[] tmpSections = new CharBlocks.Section[this.sectionCount];
            Object[] tmpSectionLocks = new Object[this.sectionCount];
            System.arraycopy(this.blocks, 0, tmpBlocks, 0, this.blocks.length);
            System.arraycopy(this.sections, 0, tmpSections, 0, this.sections.length);
            System.arraycopy(this.sectionLocks, 0, tmpSectionLocks, 0, this.sections.length);
            for (int i = this.sectionCount - diff; i < this.sectionCount; ++i) {
                tmpSections[i] = EMPTY;
                tmpSectionLocks[i] = new Object();
            }
            this.blocks = tmpBlocks;
            this.sections = tmpSections;
            this.sectionLocks = tmpSectionLocks;
            this.maxSectionPosition = layer;
            if (this.biomes != null) {
                BiomeType[][] tmpBiomes = new BiomeType[this.sectionCount][64];
                System.arraycopy(this.biomes, 0, tmpBiomes, 0, this.biomes.length);
                this.biomes = tmpBiomes;
            }
            if (this.light != null) {
                char[][] tmplight = new char[this.sectionCount][];
                System.arraycopy(this.light, 0, tmplight, 0, this.light.length);
                this.light = tmplight;
            }
            if (this.skyLight != null) {
                char[][] tmplight = new char[this.sectionCount][];
                System.arraycopy(this.skyLight, 0, tmplight, 0, this.skyLight.length);
                this.skyLight = tmplight;
            }
        }
    }
}

