/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.registry.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class PropertyKey
implements Comparable<PropertyKey> {
    private static final Map<CharSequence, PropertyKey> keys = new HashMap<CharSequence, PropertyKey>();
    private static final List<PropertyKey> keyList = new ArrayList<PropertyKey>();
    public static final PropertyKey AGE = PropertyKey.getOrCreate("age");
    public static final PropertyKey ATTACHED = PropertyKey.getOrCreate("attached");
    public static final PropertyKey ATTACHMENT = PropertyKey.getOrCreate("attachement");
    public static final PropertyKey AXIS = PropertyKey.getOrCreate("axis");
    public static final PropertyKey BERRIES = PropertyKey.getOrCreate("berries");
    public static final PropertyKey BITES = PropertyKey.getOrCreate("bites");
    public static final PropertyKey BOTTOM = PropertyKey.getOrCreate("bottom");
    public static final PropertyKey CANDLES = PropertyKey.getOrCreate("candles");
    public static final PropertyKey CHARGES = PropertyKey.getOrCreate("charges");
    public static final PropertyKey CONDITIONAL = PropertyKey.getOrCreate("conditional");
    public static final PropertyKey DELAY = PropertyKey.getOrCreate("delay");
    public static final PropertyKey DISARMED = PropertyKey.getOrCreate("disarmed");
    public static final PropertyKey DISTANCE = PropertyKey.getOrCreate("distance");
    public static final PropertyKey DOWN = PropertyKey.getOrCreate("down");
    public static final PropertyKey DRAG = PropertyKey.getOrCreate("drag");
    public static final PropertyKey EAST = PropertyKey.getOrCreate("east");
    public static final PropertyKey EGGS = PropertyKey.getOrCreate("eggs");
    public static final PropertyKey ENABLED = PropertyKey.getOrCreate("enabled");
    public static final PropertyKey EXTENDED = PropertyKey.getOrCreate("extended");
    public static final PropertyKey EYE = PropertyKey.getOrCreate("eye");
    public static final PropertyKey FACE = PropertyKey.getOrCreate("face");
    public static final PropertyKey FACING = PropertyKey.getOrCreate("facing");
    public static final PropertyKey FALLING = PropertyKey.getOrCreate("falling");
    public static final PropertyKey HALF = PropertyKey.getOrCreate("half");
    public static final PropertyKey HANGING = PropertyKey.getOrCreate("hanging");
    public static final PropertyKey HAS_BOOK = PropertyKey.getOrCreate("has_book");
    public static final PropertyKey HAS_BOTTLE_0 = PropertyKey.getOrCreate("has_bottle_0");
    public static final PropertyKey HAS_BOTTLE_1 = PropertyKey.getOrCreate("has_bottle_1");
    public static final PropertyKey HAS_BOTTLE_2 = PropertyKey.getOrCreate("has_bottle_2");
    public static final PropertyKey HAS_RECORD = PropertyKey.getOrCreate("has_record");
    public static final PropertyKey HATCH = PropertyKey.getOrCreate("hatch");
    public static final PropertyKey HINGE = PropertyKey.getOrCreate("hinge");
    public static final PropertyKey HONEY_LEVEL = PropertyKey.getOrCreate("honey_level");
    public static final PropertyKey INSTRUMENT = PropertyKey.getOrCreate("instrument");
    public static final PropertyKey INVERTED = PropertyKey.getOrCreate("inverted");
    public static final PropertyKey IN_WALL = PropertyKey.getOrCreate("in_wall");
    public static final PropertyKey LAYERS = PropertyKey.getOrCreate("layers");
    public static final PropertyKey LEAVES = PropertyKey.getOrCreate("leaves");
    public static final PropertyKey LEVEL = PropertyKey.getOrCreate("level");
    public static final PropertyKey LIT = PropertyKey.getOrCreate("lit");
    public static final PropertyKey LOCKED = PropertyKey.getOrCreate("locked");
    public static final PropertyKey MODE = PropertyKey.getOrCreate("mode");
    public static final PropertyKey MOISTURE = PropertyKey.getOrCreate("moisture");
    public static final PropertyKey NORTH = PropertyKey.getOrCreate("north");
    public static final PropertyKey NOTE = PropertyKey.getOrCreate("note");
    public static final PropertyKey OCCUPIED = PropertyKey.getOrCreate("occupied");
    public static final PropertyKey OPEN = PropertyKey.getOrCreate("open");
    public static final PropertyKey ORIENTATION = PropertyKey.getOrCreate("orientation");
    public static final PropertyKey PART = PropertyKey.getOrCreate("part");
    public static final PropertyKey PERSISTENT = PropertyKey.getOrCreate("persistent");
    public static final PropertyKey PICKLES = PropertyKey.getOrCreate("pickles");
    public static final PropertyKey POWER = PropertyKey.getOrCreate("power");
    public static final PropertyKey POWERED = PropertyKey.getOrCreate("powered");
    public static final PropertyKey ROTATION = PropertyKey.getOrCreate("rotation");
    public static final PropertyKey SCULK_SENSOR_PHASE = PropertyKey.getOrCreate("sculk_sensor_phase");
    public static final PropertyKey SHAPE = PropertyKey.getOrCreate("shape");
    public static final PropertyKey SHORT = PropertyKey.getOrCreate("short");
    public static final PropertyKey SIGNAL_FIRE = PropertyKey.getOrCreate("signal_fire");
    public static final PropertyKey SNOWY = PropertyKey.getOrCreate("snowy");
    public static final PropertyKey SOUTH = PropertyKey.getOrCreate("south");
    public static final PropertyKey STAGE = PropertyKey.getOrCreate("stage");
    public static final PropertyKey TILT = PropertyKey.getOrCreate("tilt");
    public static final PropertyKey THICKNESS = PropertyKey.getOrCreate("thickness");
    public static final PropertyKey TRIGGERED = PropertyKey.getOrCreate("triggered");
    public static final PropertyKey TYPE = PropertyKey.getOrCreate("type");
    public static final PropertyKey UNSTABLE = PropertyKey.getOrCreate("unstable");
    public static final PropertyKey UP = PropertyKey.getOrCreate("up");
    public static final PropertyKey VERTICAL_DIRECTION = PropertyKey.getOrCreate("vertical_direction");
    public static final PropertyKey VINE_END = PropertyKey.getOrCreate("vine_end");
    public static final PropertyKey WATERLOGGED = PropertyKey.getOrCreate("waterlogged");
    public static final PropertyKey WEST = PropertyKey.getOrCreate("west");
    private final String name;
    private final int id;

    private PropertyKey(String name, int ordinal) {
        this.name = name;
        this.id = ordinal;
    }

    public static int getCount() {
        return keyList.size();
    }

    public static PropertyKey getByName(CharSequence name) {
        return keys.get(name);
    }

    public static PropertyKey getById(int id) {
        return keyList.get(id);
    }

    public static PropertyKey getOrCreate(String id) {
        return keys.computeIfAbsent(id, k -> {
            PropertyKey key = new PropertyKey(id, keyList.size());
            keyList.add(key);
            return key;
        });
    }

    public final String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int compareTo(@Nonnull PropertyKey o) {
        return Integer.compare(this.id, o.id);
    }
}

