/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.util.DelegateTextureUtil;
import com.fastasyncworldedit.core.util.TextureUtil;
import com.sk89q.worldedit.world.block.BlockType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileNotFoundException;

public class CachedTextureUtil
extends DelegateTextureUtil {
    private final TextureUtil parent;
    private final transient Int2ObjectOpenHashMap<BlockType> colorBlockMap;
    private final transient Int2ObjectOpenHashMap<Integer> colorBiomeMap;
    private final transient Int2ObjectOpenHashMap<BlockType[]> colorLayerMap;

    public CachedTextureUtil(TextureUtil parent) throws FileNotFoundException {
        super(parent);
        this.parent = parent;
        this.colorBlockMap = new Int2ObjectOpenHashMap();
        this.colorLayerMap = new Int2ObjectOpenHashMap();
        this.colorBiomeMap = new Int2ObjectOpenHashMap();
    }

    @Override
    public BlockType[] getNearestLayer(int color) {
        BlockType[] closest = (BlockType[])this.colorLayerMap.get(color);
        if (closest != null) {
            return closest;
        }
        closest = this.parent.getNearestLayer(color);
        if (closest != null) {
            this.colorLayerMap.put(color, (Object)((BlockType[])closest.clone()));
        }
        return closest;
    }

    @Override
    public TextureUtil.BiomeColor getNearestBiome(int color) {
        Integer value = (Integer)this.colorBiomeMap.get(color);
        if (value != null) {
            return this.getBiome(value);
        }
        TextureUtil.BiomeColor result = this.parent.getNearestBiome(color);
        if (result != null) {
            this.colorBiomeMap.put(color, (Object)result.id);
        }
        return result;
    }

    @Override
    public BlockType getNearestBlock(int color) {
        BlockType value = (BlockType)this.colorBlockMap.get(color);
        if (value != null) {
            return value;
        }
        BlockType result = this.parent.getNearestBlock(color);
        if (result != null) {
            this.colorBlockMap.put(color, (Object)result);
        }
        return result;
    }
}

