/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.configuration.Settings;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class MemUtil {
    private static final AtomicBoolean memory = new AtomicBoolean(false);
    private static final Queue<Runnable> memoryLimitedTasks = new ConcurrentLinkedQueue<Runnable>();
    private static final Queue<Runnable> memoryPlentifulTasks = new ConcurrentLinkedQueue<Runnable>();

    public static boolean isMemoryFree() {
        return !memory.get();
    }

    public static boolean isMemoryLimited() {
        return memory.get();
    }

    public static boolean isMemoryLimitedSlow() {
        if (memory.get()) {
            System.gc();
            System.gc();
            MemUtil.calculateMemory();
            return memory.get();
        }
        return false;
    }

    public static long getUsedBytes() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long getFreeBytes() {
        return Runtime.getRuntime().maxMemory() - MemUtil.getUsedBytes();
    }

    public static int calculateMemory() {
        long heapMaxSize;
        long heapSize = Runtime.getRuntime().totalMemory();
        if (heapSize < (heapMaxSize = Runtime.getRuntime().maxMemory())) {
            return Integer.MAX_VALUE;
        }
        long heapFreeSize = Runtime.getRuntime().freeMemory();
        int size = (int)(heapFreeSize * 100L / heapMaxSize);
        if (size > 100 - Settings.settings().MAX_MEMORY_PERCENT) {
            MemUtil.memoryPlentifulTask();
            return Integer.MAX_VALUE;
        }
        return size;
    }

    public static void addMemoryLimitedTask(Runnable run) {
        if (run != null) {
            memoryLimitedTasks.add(run);
        }
    }

    public static void addMemoryPlentifulTask(Runnable run) {
        if (run != null) {
            memoryPlentifulTasks.add(run);
        }
    }

    public static void memoryLimitedTask() {
        System.gc();
        System.gc();
        for (Runnable task : memoryLimitedTasks) {
            task.run();
        }
        memory.set(true);
    }

    public static void memoryPlentifulTask() {
        for (Runnable task : memoryPlentifulTasks) {
            task.run();
        }
        memory.set(false);
    }
}

